/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.com.google.common.collect.ImmutableSet;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexFieldAccess;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.rex.RexVisitorImpl;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import java.util.List;
import java.util.Set;

public class RexMultisetUtil {
    private static final Set<SqlOperator> MULTISET_OPERATORS = ImmutableSet.of(SqlStdOperatorTable.CARDINALITY, SqlStdOperatorTable.CAST, SqlStdOperatorTable.ELEMENT, SqlStdOperatorTable.ELEMENT_SLICE, SqlStdOperatorTable.MULTISET_EXCEPT_ALL, SqlStdOperatorTable.MULTISET_EXCEPT, new SqlOperator[]{SqlStdOperatorTable.MULTISET_INTERSECT_ALL, SqlStdOperatorTable.MULTISET_INTERSECT, SqlStdOperatorTable.MULTISET_UNION_ALL, SqlStdOperatorTable.MULTISET_UNION, SqlStdOperatorTable.IS_A_SET, SqlStdOperatorTable.MEMBER_OF, SqlStdOperatorTable.SUBMULTISET_OF});

    private RexMultisetUtil() {
    }

    public static boolean containsMixing(RexProgram program) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        for (RexNode expr : program.getExprList()) {
            counter.reset();
            expr.accept(counter);
            if (counter.totalCount == counter.multisetCount || 0 == counter.multisetCount) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMixing(RexNode node) {
        RexCallMultisetOperatorCounter counter = new RexCallMultisetOperatorCounter();
        node.accept(counter);
        return counter.totalCount != counter.multisetCount && 0 != counter.multisetCount;
    }

    public static boolean containsMultiset(RexNode node, boolean deep) {
        return null != RexMultisetUtil.findFirstMultiset(node, deep);
    }

    public static boolean containsMultiset(List<RexNode> nodes, boolean deep) {
        for (RexNode node : nodes) {
            if (!RexMultisetUtil.containsMultiset(node, deep)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMultiset(RexProgram program) {
        return RexMultisetUtil.containsMultiset(program.getExprList(), true);
    }

    public static boolean isMultisetCast(RexCall call) {
        if (!call.getOperator().equals(SqlStdOperatorTable.CAST)) {
            return false;
        }
        return call.getType().getSqlTypeName() == SqlTypeName.MULTISET;
    }

    public static RexCall findFirstMultiset(RexNode node, boolean deep) {
        if (node instanceof RexFieldAccess) {
            return RexMultisetUtil.findFirstMultiset(((RexFieldAccess)node).getReferenceExpr(), deep);
        }
        if (!(node instanceof RexCall)) {
            return null;
        }
        RexCall call = (RexCall)node;
        RexCall firstOne = null;
        for (SqlOperator op : MULTISET_OPERATORS) {
            firstOne = RexUtil.findOperatorCall(op, call);
            if (null == firstOne) continue;
            if (!firstOne.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(firstOne)) break;
            firstOne = null;
        }
        if (!deep && firstOne != call) {
            return null;
        }
        return firstOne;
    }

    private static class RexCallMultisetOperatorCounter
    extends RexVisitorImpl<Void> {
        int totalCount = 0;
        int multisetCount = 0;

        RexCallMultisetOperatorCounter() {
            super(true);
        }

        void reset() {
            this.totalCount = 0;
            this.multisetCount = 0;
        }

        @Override
        public Void visitCall(RexCall call) {
            ++this.totalCount;
            if (MULTISET_OPERATORS.contains(call.getOperator()) && (!call.getOperator().equals(SqlStdOperatorTable.CAST) || RexMultisetUtil.isMultisetCast(call))) {
                ++this.multisetCount;
            }
            return (Void)super.visitCall(call);
        }
    }
}

