/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.com.google.common.base.Objects;
import hive.org.apache.calcite.avatica.util.ByteString;
import hive.org.apache.calcite.avatica.util.DateTimeUtils;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexVisitor;
import hive.org.apache.calcite.sql.SqlCollation;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.parser.SqlParserUtil;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.util.ConversionUtil;
import hive.org.apache.calcite.util.Litmus;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.SaffronProperties;
import hive.org.apache.calcite.util.Util;
import hive.org.apache.calcite.util.ZonelessDate;
import hive.org.apache.calcite.util.ZonelessDatetime;
import hive.org.apache.calcite.util.ZonelessTime;
import hive.org.apache.calcite.util.ZonelessTimestamp;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class RexLiteral
extends RexNode {
    private final Comparable value;
    private final RelDataType type;
    private final SqlTypeName typeName;

    RexLiteral(Comparable value, RelDataType type, SqlTypeName typeName) {
        assert (type != null);
        assert (value == null || RexLiteral.valueMatchesType(value, typeName, true));
        assert (value == null == type.isNullable());
        assert (typeName != SqlTypeName.ANY);
        this.value = value;
        this.type = type;
        this.typeName = typeName;
        this.digest = RexLiteral.toJavaString(value, typeName);
    }

    public static boolean valueMatchesType(Comparable value, SqlTypeName typeName, boolean strict) {
        if (value == null) {
            return true;
        }
        switch (typeName) {
            case BOOLEAN: {
                return value instanceof Boolean;
            }
            case NULL: {
                return false;
            }
            case INTEGER: 
            case TINYINT: 
            case SMALLINT: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case DECIMAL: 
            case DOUBLE: 
            case FLOAT: 
            case REAL: 
            case BIGINT: {
                return value instanceof BigDecimal;
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                return value instanceof Calendar;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                return value instanceof BigDecimal;
            }
            case VARBINARY: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case BINARY: {
                return value instanceof ByteString;
            }
            case VARCHAR: {
                if (strict) {
                    throw Util.unexpected(typeName);
                }
            }
            case CHAR: {
                return value instanceof NlsString && ((NlsString)value).getCharset() != null && ((NlsString)value).getCollation() != null;
            }
            case SYMBOL: {
                return value instanceof Enum;
            }
            case MAP: {
                return value instanceof Map;
            }
            case ANY: {
                return false;
            }
        }
        throw Util.unexpected(typeName);
    }

    private static String toJavaString(Comparable value, SqlTypeName typeName) {
        if (value == null) {
            return "null";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        RexLiteral.printAsJava(value, pw, typeName, false);
        pw.flush();
        return sw.toString();
    }

    public static boolean validConstant(Object o, Litmus litmus) {
        if (o == null || o instanceof BigDecimal || o instanceof NlsString || o instanceof ByteString) {
            return litmus.succeed();
        }
        if (o instanceof List) {
            List list = (List)o;
            for (Object o1 : list) {
                if (RexLiteral.validConstant(o1, litmus)) continue;
                return litmus.fail("not a constant: " + o1);
            }
            return litmus.succeed();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            for (Map.Entry entry : map.entrySet()) {
                if (!RexLiteral.validConstant(entry.getKey(), litmus)) {
                    return litmus.fail("not a constant: " + entry.getKey());
                }
                if (RexLiteral.validConstant(entry.getValue(), litmus)) continue;
                return litmus.fail("not a constant: " + entry.getValue());
            }
            return litmus.succeed();
        }
        return litmus.fail("not a constant: " + o);
    }

    public void printAsJava(PrintWriter pw) {
        RexLiteral.printAsJava(this.value, pw, this.typeName, true);
    }

    private static void printAsJava(Comparable value, PrintWriter pw, SqlTypeName typeName, boolean java) {
        switch (typeName) {
            case CHAR: {
                NlsString nlsString = (NlsString)value;
                if (java) {
                    Util.printJavaString(pw, nlsString.getValue(), true);
                    break;
                }
                boolean includeCharset = nlsString.getCharsetName() != null && !nlsString.getCharsetName().equals(SaffronProperties.instance().defaultCharset.get());
                pw.print(nlsString.asSql(includeCharset, false));
                break;
            }
            case BOOLEAN: {
                assert (value instanceof Boolean);
                pw.print((Boolean)value);
                break;
            }
            case DECIMAL: {
                assert (value instanceof BigDecimal);
                pw.print(value.toString());
                break;
            }
            case DOUBLE: {
                assert (value instanceof BigDecimal);
                pw.print(Util.toScientificNotation((BigDecimal)value));
                break;
            }
            case BIGINT: {
                assert (value instanceof BigDecimal);
                pw.print(((BigDecimal)value).longValue());
                pw.print('L');
                break;
            }
            case BINARY: {
                assert (value instanceof ByteString);
                pw.print("X'");
                pw.print(((ByteString)value).toString(16));
                pw.print("'");
                break;
            }
            case NULL: {
                assert (value == null);
                pw.print("null");
                break;
            }
            case SYMBOL: {
                assert (value instanceof Enum);
                pw.print("FLAG(");
                pw.print(value);
                pw.print(")");
                break;
            }
            case DATE: {
                RexLiteral.printDatetime(pw, new ZonelessDate(), value);
                break;
            }
            case TIME: {
                RexLiteral.printDatetime(pw, new ZonelessTime(), value);
                break;
            }
            case TIMESTAMP: {
                RexLiteral.printDatetime(pw, new ZonelessTimestamp(), value);
                break;
            }
            case MAP: {
                pw.print(value.toString());
                break;
            }
            case INTERVAL_DAY_TIME: 
            case INTERVAL_YEAR_MONTH: {
                if (value instanceof BigDecimal) {
                    pw.print(value.toString());
                    break;
                }
                assert (value == null);
                pw.print("null");
                break;
            }
            default: {
                assert (RexLiteral.valueMatchesType(value, typeName, true));
                throw Util.needToImplement((Object)typeName);
            }
        }
    }

    private static void printDatetime(PrintWriter pw, ZonelessDatetime datetime, Comparable value) {
        assert (value instanceof Calendar);
        datetime.setZonelessTime(((Calendar)value).getTimeInMillis());
        pw.print(datetime);
    }

    public static RexLiteral fromJdbcString(RelDataType type, SqlTypeName typeName, String literal) {
        if (literal == null) {
            return null;
        }
        switch (typeName) {
            case CHAR: {
                Charset charset = type.getCharset();
                SqlCollation collation = type.getCollation();
                NlsString str = new NlsString(literal, charset.name(), collation);
                return new RexLiteral(str, type, typeName);
            }
            case BOOLEAN: {
                boolean b = ConversionUtil.toBoolean(literal);
                return new RexLiteral(Boolean.valueOf(b), type, typeName);
            }
            case DECIMAL: 
            case DOUBLE: {
                BigDecimal d = new BigDecimal(literal);
                return new RexLiteral(d, type, typeName);
            }
            case BINARY: {
                byte[] bytes = ConversionUtil.toByteArrayFromString(literal, 16);
                return new RexLiteral(new ByteString(bytes), type, typeName);
            }
            case NULL: {
                return new RexLiteral(null, type, typeName);
            }
            case INTERVAL_DAY_TIME: {
                long millis = SqlParserUtil.intervalToMillis(literal, type.getIntervalQualifier());
                return new RexLiteral(BigDecimal.valueOf(millis), type, typeName);
            }
            case INTERVAL_YEAR_MONTH: {
                long months = SqlParserUtil.intervalToMonths(literal, type.getIntervalQualifier());
                return new RexLiteral(BigDecimal.valueOf(months), type, typeName);
            }
            case DATE: 
            case TIME: 
            case TIMESTAMP: {
                String format = RexLiteral.getCalendarFormat(typeName);
                TimeZone tz = DateTimeUtils.GMT_ZONE;
                Calendar cal = null;
                if (typeName == SqlTypeName.DATE) {
                    cal = DateTimeUtils.parseDateFormat(literal, format, tz);
                } else {
                    DateTimeUtils.PrecisionTime ts = DateTimeUtils.parsePrecisionDateTimeLiteral(literal, format, tz);
                    if (ts != null) {
                        cal = ts.getCalendar();
                    }
                }
                if (cal == null) {
                    throw Util.newInternal("fromJdbcString: invalid date/time value '" + literal + "'");
                }
                return new RexLiteral(cal, type, typeName);
            }
        }
        throw Util.newInternal("fromJdbcString: unsupported type");
    }

    private static String getCalendarFormat(SqlTypeName typeName) {
        switch (typeName) {
            case DATE: {
                return "yyyy-MM-dd";
            }
            case TIME: {
                return "HH:mm:ss";
            }
            case TIMESTAMP: {
                return "yyyy-MM-dd HH:mm:ss";
            }
        }
        throw Util.newInternal("getCalendarFormat: unknown type");
    }

    public SqlTypeName getTypeName() {
        return this.typeName;
    }

    @Override
    public RelDataType getType() {
        return this.type;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.LITERAL;
    }

    public Comparable getValue() {
        assert (RexLiteral.valueMatchesType(this.value, this.typeName, true)) : this.value;
        return this.value;
    }

    public Object getValue2() {
        if (this.value == null) {
            return null;
        }
        switch (this.typeName) {
            case BINARY: {
                return ((ByteBuffer)this.value).array();
            }
            case CHAR: {
                return ((NlsString)this.value).getValue();
            }
            case DECIMAL: {
                return ((BigDecimal)this.value).unscaledValue().longValue();
            }
            case DATE: {
                return (int)(((Calendar)this.value).getTimeInMillis() / 86400000L);
            }
            case TIME: {
                return (int)(((Calendar)this.value).getTimeInMillis() % 86400000L);
            }
            case TIMESTAMP: {
                return ((Calendar)this.value).getTimeInMillis();
            }
        }
        return this.value;
    }

    public Object getValue3() {
        switch (this.typeName) {
            case DECIMAL: {
                assert (this.value instanceof BigDecimal);
                return this.value;
            }
        }
        return this.getValue2();
    }

    public static boolean booleanValue(RexNode node) {
        return (Boolean)((RexLiteral)node).value;
    }

    @Override
    public boolean isAlwaysTrue() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return RexLiteral.booleanValue(this);
    }

    @Override
    public boolean isAlwaysFalse() {
        if (this.typeName != SqlTypeName.BOOLEAN) {
            return false;
        }
        return !RexLiteral.booleanValue(this);
    }

    public boolean equals(Object obj) {
        return obj instanceof RexLiteral && RexLiteral.equals(((RexLiteral)obj).value, this.value) && RexLiteral.equals(((RexLiteral)obj).type, this.type);
    }

    public int hashCode() {
        return Objects.hashCode(this.value, this.type);
    }

    public static Comparable value(RexNode node) {
        return RexLiteral.findValue(node);
    }

    public static int intValue(RexNode node) {
        Comparable value = RexLiteral.findValue(node);
        return ((Number)((Object)value)).intValue();
    }

    public static String stringValue(RexNode node) {
        Comparable value = RexLiteral.findValue(node);
        return value == null ? null : ((NlsString)value).getValue();
    }

    private static Comparable findValue(RexNode node) {
        if (node instanceof RexLiteral) {
            return ((RexLiteral)node).value;
        }
        if (node instanceof RexCall) {
            RexCall call = (RexCall)node;
            SqlOperator operator = call.getOperator();
            if (operator == SqlStdOperatorTable.CAST) {
                return RexLiteral.findValue(call.getOperands().get(0));
            }
            if (operator == SqlStdOperatorTable.UNARY_MINUS) {
                BigDecimal value = (BigDecimal)RexLiteral.findValue(call.getOperands().get(0));
                return value.negate();
            }
        }
        throw Util.newInternal("not a literal: " + node);
    }

    public static boolean isNullLiteral(RexNode node) {
        return node instanceof RexLiteral && ((RexLiteral)node).value == null;
    }

    private static boolean equals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    @Override
    public <R> R accept(RexVisitor<R> visitor) {
        return visitor.visitLiteral(this);
    }
}

