/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rex;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.runtime.CalciteException;
import hive.org.apache.calcite.runtime.Resources;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.SqlOperatorBinding;
import hive.org.apache.calcite.sql.SqlUtil;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.sql.validate.SqlValidatorException;
import java.util.List;

public class RexCallBinding
extends SqlOperatorBinding {
    private final List<RexNode> operands;
    private final List<RelCollation> inputCollations;

    public RexCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands, List<RelCollation> inputCollations) {
        super(typeFactory, sqlOperator);
        this.operands = ImmutableList.copyOf(operands);
        this.inputCollations = ImmutableList.copyOf(inputCollations);
    }

    public static RexCallBinding create(RelDataTypeFactory typeFactory, RexCall call, List<RelCollation> inputCollations) {
        switch (call.getKind()) {
            case CAST: {
                return new RexCastCallBinding(typeFactory, call.getOperator(), call.getOperands(), call.getType(), inputCollations);
            }
        }
        return new RexCallBinding(typeFactory, call.getOperator(), call.getOperands(), inputCollations);
    }

    @Override
    public String getStringLiteralOperand(int ordinal) {
        return RexLiteral.stringValue(this.operands.get(ordinal));
    }

    @Override
    public int getIntLiteralOperand(int ordinal) {
        return RexLiteral.intValue(this.operands.get(ordinal));
    }

    @Override
    public Comparable getOperandLiteralValue(int ordinal) {
        return RexLiteral.value(this.operands.get(ordinal));
    }

    @Override
    public SqlMonotonicity getOperandMonotonicity(int ordinal) {
        RexNode operand = this.operands.get(ordinal);
        if (operand instanceof RexInputRef) {
            for (RelCollation ic : this.inputCollations) {
                if (ic.getFieldCollations().isEmpty()) continue;
                for (RelFieldCollation rfc : ic.getFieldCollations()) {
                    if (rfc.getFieldIndex() != ((RexInputRef)operand).getIndex()) continue;
                    return rfc.direction.monotonicity();
                }
            }
        } else if (operand instanceof RexCall) {
            RexCallBinding binding = RexCallBinding.create(this.typeFactory, (RexCall)operand, this.inputCollations);
            ((RexCall)operand).getOperator().getMonotonicity(binding);
        }
        return SqlMonotonicity.NOT_MONOTONIC;
    }

    @Override
    public boolean isOperandNull(int ordinal, boolean allowCast) {
        return RexUtil.isNullLiteral(this.operands.get(ordinal), allowCast);
    }

    @Override
    public int getOperandCount() {
        return this.operands.size();
    }

    @Override
    public RelDataType getOperandType(int ordinal) {
        return this.operands.get(ordinal).getType();
    }

    @Override
    public CalciteException newError(Resources.ExInst<SqlValidatorException> e) {
        return SqlUtil.newContextException(SqlParserPos.ZERO, e);
    }

    private static class RexCastCallBinding
    extends RexCallBinding {
        private final RelDataType type;

        public RexCastCallBinding(RelDataTypeFactory typeFactory, SqlOperator sqlOperator, List<? extends RexNode> operands, RelDataType type, List<RelCollation> inputCollations) {
            super(typeFactory, sqlOperator, operands, inputCollations);
            this.type = type;
        }

        @Override
        public RelDataType getOperandType(int ordinal) {
            if (ordinal == 1) {
                return this.type;
            }
            return super.getOperandType(ordinal);
        }
    }
}

