/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.rules.ProjectRemoveRule;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.IntList;
import java.util.ArrayList;

public class SemiJoinRule
extends RelOptRule {
    public static final SemiJoinRule INSTANCE = new SemiJoinRule();

    private SemiJoinRule() {
        super(SemiJoinRule.operand(Project.class, SemiJoinRule.some(SemiJoinRule.operand(Join.class, SemiJoinRule.some(SemiJoinRule.operand(RelNode.class, SemiJoinRule.any()), SemiJoinRule.operand(Aggregate.class, SemiJoinRule.any()))), new RelOptRuleOperand[0])));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ImmutableBitSet rightBits;
        Project project = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        Object left = call.rel(2);
        Aggregate aggregate = (Aggregate)call.rel(3);
        RelOptCluster cluster = join.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        ImmutableBitSet bits = RelOptUtil.InputFinder.bits(project.getProjects(), null);
        if (bits.intersects(rightBits = ImmutableBitSet.range(left.getRowType().getFieldCount(), join.getRowType().getFieldCount()))) {
            return;
        }
        JoinInfo joinInfo = join.analyzeCondition();
        if (!joinInfo.rightSet().equals(ImmutableBitSet.range(aggregate.getGroupCount()))) {
            return;
        }
        if (!joinInfo.isEqui()) {
            return;
        }
        ArrayList newRightKeyBuilder = Lists.newArrayList();
        IntList aggregateKeys = aggregate.getGroupSet().toList();
        for (int key : joinInfo.rightKeys) {
            newRightKeyBuilder.add(aggregateKeys.get(key));
        }
        ImmutableIntList newRightKeys = ImmutableIntList.copyOf(newRightKeyBuilder);
        RelNode newRight = aggregate.getInput();
        RexNode newCondition = RelOptUtil.createEquiJoinCondition(left, joinInfo.leftKeys, newRight, newRightKeys, rexBuilder);
        SemiJoin semiJoin = SemiJoin.create(left, newRight, newCondition, joinInfo.leftKeys, newRightKeys);
        Project newProject = project.copy(project.getTraitSet(), semiJoin, project.getProjects(), project.getRowType());
        call.transformTo(ProjectRemoveRule.strip(newProject));
    }
}

