/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.base.Predicate;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumerableInterpreter;
import hive.org.apache.calcite.interpreter.Bindables;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.schema.ProjectableFilterableTable;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.mapping.Mapping;
import hive.org.apache.calcite.util.mapping.Mappings;
import java.util.List;

public abstract class ProjectTableScanRule
extends RelOptRule {
    public static final Predicate<TableScan> PREDICATE = new Predicate<TableScan>(){

        @Override
        public boolean apply(TableScan scan) {
            RelOptTable table = scan.getTable();
            return table.unwrap(ProjectableFilterableTable.class) != null;
        }
    };
    public static final ProjectTableScanRule INSTANCE = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(TableScan.class, null, PREDICATE, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), "ProjectScanRule"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(1);
            this.apply(call, project, scan);
        }
    };
    public static final ProjectTableScanRule INTERPRETER = new ProjectTableScanRule(ProjectTableScanRule.operand(Project.class, ProjectTableScanRule.operand(EnumerableInterpreter.class, ProjectTableScanRule.operand(TableScan.class, null, PREDICATE, ProjectTableScanRule.none()), new RelOptRuleOperand[0]), new RelOptRuleOperand[0]), "ProjectScanRule:interpreter"){

        @Override
        public void onMatch(RelOptRuleCall call) {
            Project project = (Project)call.rel(0);
            TableScan scan = (TableScan)call.rel(2);
            this.apply(call, project, scan);
        }
    };

    private ProjectTableScanRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    protected void apply(RelOptRuleCall call, Project project, TableScan scan) {
        ImmutableIntList projects;
        ImmutableList<RexNode> filters;
        RelOptTable table = scan.getTable();
        assert (table.unwrap(ProjectableFilterableTable.class) != null);
        Mappings.TargetMapping mapping = project.getMapping();
        if (mapping == null || Mappings.isIdentity(mapping)) {
            return;
        }
        if (scan instanceof Bindables.BindableTableScan) {
            Bindables.BindableTableScan bindableScan = (Bindables.BindableTableScan)scan;
            filters = bindableScan.filters;
            projects = bindableScan.projects;
        } else {
            filters = ImmutableList.of();
            projects = scan.identity();
        }
        List<Integer> projects2 = Mappings.apply((Mapping)mapping, projects);
        call.transformTo(Bindables.BindableTableScan.create(scan.getCluster(), scan.getTable(), filters, projects2));
    }
}

