/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.rules.PushProjector;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexOver;

public class ProjectFilterTransposeRule
extends RelOptRule {
    public static final ProjectFilterTransposeRule INSTANCE = new ProjectFilterTransposeRule(PushProjector.ExprCondition.FALSE);
    private final PushProjector.ExprCondition preserveExprCondition;

    protected ProjectFilterTransposeRule(PushProjector.ExprCondition preserveExprCondition) {
        super(ProjectFilterTransposeRule.operand(LogicalProject.class, ProjectFilterTransposeRule.operand(LogicalFilter.class, ProjectFilterTransposeRule.any()), new RelOptRuleOperand[0]));
        this.preserveExprCondition = preserveExprCondition;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        LogicalFilter filter;
        LogicalProject origProj;
        if (call.rels.length == 2) {
            origProj = (LogicalProject)call.rel(0);
            filter = (LogicalFilter)call.rel(1);
        } else {
            origProj = null;
            filter = (LogicalFilter)call.rel(0);
        }
        RelNode rel = filter.getInput();
        RexNode origFilter = filter.getCondition();
        if (origProj != null && RexOver.containsOver(origProj.getProjects(), null)) {
            return;
        }
        PushProjector pushProjector = new PushProjector(origProj, origFilter, rel, this.preserveExprCondition);
        RelNode topProject = pushProjector.convertProject(null);
        if (topProject != null) {
            call.transformTo(topProject);
        }
    }
}

