/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.logical.LogicalUnion;
import java.util.ArrayList;

public class JoinUnionTransposeRule
extends RelOptRule {
    public static final JoinUnionTransposeRule LEFT_UNION = new JoinUnionTransposeRule(JoinUnionTransposeRule.operand(Join.class, JoinUnionTransposeRule.operand(Union.class, JoinUnionTransposeRule.any()), JoinUnionTransposeRule.operand(RelNode.class, JoinUnionTransposeRule.any())), "JoinUnionTransposeRule(Union-Other)");
    public static final JoinUnionTransposeRule RIGHT_UNION = new JoinUnionTransposeRule(JoinUnionTransposeRule.operand(Join.class, JoinUnionTransposeRule.operand(RelNode.class, JoinUnionTransposeRule.any()), JoinUnionTransposeRule.operand(Union.class, JoinUnionTransposeRule.any())), "JoinUnionTransposeRule(Other-Union)");

    private JoinUnionTransposeRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        boolean unionOnLeft;
        Object otherInput;
        Union unionRel;
        Join join = (Join)call.rel(0);
        if (call.rel(1) instanceof LogicalUnion) {
            unionRel = (Union)call.rel(1);
            otherInput = call.rel(2);
            unionOnLeft = true;
        } else {
            otherInput = call.rel(1);
            unionRel = (Union)call.rel(2);
            unionOnLeft = false;
        }
        if (!unionRel.all) {
            return;
        }
        if (!join.getVariablesStopped().isEmpty()) {
            return;
        }
        if (unionOnLeft ? join.getJoinType().generatesNullsOnLeft() : join.getJoinType().generatesNullsOnRight()) {
            return;
        }
        ArrayList<RelNode> newUnionInputs = new ArrayList<RelNode>();
        for (RelNode input : unionRel.getInputs()) {
            Object joinRight;
            RelNode joinLeft;
            if (unionOnLeft) {
                joinLeft = input;
                joinRight = otherInput;
            } else {
                joinLeft = otherInput;
                joinRight = input;
            }
            newUnionInputs.add(join.copy(join.getTraitSet(), join.getCondition(), joinLeft, (RelNode)joinRight, join.getJoinType(), join.isSemiJoinDone()));
        }
        SetOp newUnionRel = unionRel.copy(unionRel.getTraitSet(), newUnionInputs, true);
        call.transformTo(newUnionRel);
    }
}

