/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.rules;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.Union;
import hive.org.apache.calcite.rel.logical.LogicalAggregate;
import hive.org.apache.calcite.rel.logical.LogicalUnion;
import hive.org.apache.calcite.sql.SqlKind;

public class AggregateUnionAggregateRule
extends RelOptRule {
    public static final AggregateUnionAggregateRule INSTANCE = new AggregateUnionAggregateRule(LogicalAggregate.class, RelFactories.DEFAULT_AGGREGATE_FACTORY, LogicalUnion.class, RelFactories.DEFAULT_SET_OP_FACTORY);
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SetOpFactory setOpFactory;

    public AggregateUnionAggregateRule(Class<? extends Aggregate> aggregateClass, RelFactories.AggregateFactory aggregateFactory, Class<? extends Union> unionClass, RelFactories.SetOpFactory setOpFactory) {
        super(AggregateUnionAggregateRule.operand(aggregateClass, null, Aggregate.IS_SIMPLE, AggregateUnionAggregateRule.operand(unionClass, AggregateUnionAggregateRule.operand(RelNode.class, AggregateUnionAggregateRule.any()), AggregateUnionAggregateRule.operand(RelNode.class, AggregateUnionAggregateRule.any())), new RelOptRuleOperand[0]));
        this.aggregateFactory = aggregateFactory;
        this.setOpFactory = setOpFactory;
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        ImmutableList<RelNode> unionInputs;
        Aggregate bottomAggRel;
        Union union = (Union)call.rel(1);
        if (!union.all) {
            return;
        }
        Aggregate topAggRel = (Aggregate)call.rel(0);
        if (call.rel(3) instanceof Aggregate) {
            bottomAggRel = (Aggregate)call.rel(3);
            unionInputs = ImmutableList.of(call.rel(2), call.rel(3).getInput(0));
        } else if (call.rel(2) instanceof Aggregate) {
            bottomAggRel = (Aggregate)call.rel(2);
            unionInputs = ImmutableList.of(call.rel(2).getInput(0), call.rel(3));
        } else {
            return;
        }
        if (!topAggRel.getAggCallList().isEmpty() || !bottomAggRel.getAggCallList().isEmpty()) {
            return;
        }
        RelNode newUnion = this.setOpFactory.createSetOp(SqlKind.UNION, unionInputs, true);
        RelNode newAggRel = this.aggregateFactory.createAggregate(newUnion, false, topAggRel.getGroupSet(), null, topAggRel.getAggCallList());
        call.transformTo(newAggRel);
    }
}

