/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPredicateList;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.BuiltInMetadata;
import hive.org.apache.calcite.rel.metadata.RelColumnOrigin;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlExplainLevel;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class RelMetadataQuery {
    public static Double getRowCount(RelNode rel) {
        BuiltInMetadata.RowCount metadata = rel.metadata(BuiltInMetadata.RowCount.class);
        Double result = metadata.getRowCount();
        return RelMetadataQuery.validateResult(result);
    }

    public static RelOptCost getCumulativeCost(RelNode rel) {
        BuiltInMetadata.CumulativeCost metadata = rel.metadata(BuiltInMetadata.CumulativeCost.class);
        return metadata.getCumulativeCost();
    }

    public static RelOptCost getNonCumulativeCost(RelNode rel) {
        BuiltInMetadata.NonCumulativeCost metadata = rel.metadata(BuiltInMetadata.NonCumulativeCost.class);
        return metadata.getNonCumulativeCost();
    }

    public static Double getPercentageOriginalRows(RelNode rel) {
        BuiltInMetadata.PercentageOriginalRows metadata = rel.metadata(BuiltInMetadata.PercentageOriginalRows.class);
        Double result = metadata.getPercentageOriginalRows();
        assert (RelMetadataQuery.isPercentage(result, true));
        return result;
    }

    public static Set<RelColumnOrigin> getColumnOrigins(RelNode rel, int column) {
        BuiltInMetadata.ColumnOrigin metadata = rel.metadata(BuiltInMetadata.ColumnOrigin.class);
        return metadata.getColumnOrigins(column);
    }

    public static RelColumnOrigin getColumnOrigin(RelNode rel, int column) {
        Set<RelColumnOrigin> origins = RelMetadataQuery.getColumnOrigins(rel, column);
        if (origins == null || origins.size() != 1) {
            return null;
        }
        RelColumnOrigin origin = Iterables.getOnlyElement(origins);
        return origin.isDerived() ? null : origin;
    }

    public static RelOptTable getTableOrigin(RelNode rel) {
        Set<RelColumnOrigin> colOrigins = RelMetadataQuery.getColumnOrigins(rel, 0);
        if (colOrigins == null || colOrigins.size() == 0) {
            return null;
        }
        return colOrigins.iterator().next().getOriginTable();
    }

    public static Double getSelectivity(RelNode rel, RexNode predicate) {
        BuiltInMetadata.Selectivity metadata = rel.metadata(BuiltInMetadata.Selectivity.class);
        Double result = metadata.getSelectivity(predicate);
        assert (RelMetadataQuery.isPercentage(result, true));
        return result;
    }

    public static Set<ImmutableBitSet> getUniqueKeys(RelNode rel) {
        BuiltInMetadata.UniqueKeys metadata = rel.metadata(BuiltInMetadata.UniqueKeys.class);
        return metadata.getUniqueKeys(false);
    }

    public static Set<ImmutableBitSet> getUniqueKeys(RelNode rel, boolean ignoreNulls) {
        BuiltInMetadata.UniqueKeys metadata = rel.metadata(BuiltInMetadata.UniqueKeys.class);
        return metadata.getUniqueKeys(ignoreNulls);
    }

    public static Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns) {
        BuiltInMetadata.ColumnUniqueness metadata = rel.metadata(BuiltInMetadata.ColumnUniqueness.class);
        return metadata.areColumnsUnique(columns, false);
    }

    public static Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        BuiltInMetadata.ColumnUniqueness metadata = rel.metadata(BuiltInMetadata.ColumnUniqueness.class);
        return metadata.areColumnsUnique(columns, ignoreNulls);
    }

    public static ImmutableList<RelCollation> collations(RelNode rel) {
        BuiltInMetadata.Collation metadata = rel.metadata(BuiltInMetadata.Collation.class);
        return metadata.collations();
    }

    public static RelDistribution distribution(RelNode rel) {
        BuiltInMetadata.Distribution metadata = rel.metadata(BuiltInMetadata.Distribution.class);
        return metadata.distribution();
    }

    public static Double getPopulationSize(RelNode rel, ImmutableBitSet groupKey) {
        BuiltInMetadata.PopulationSize metadata = rel.metadata(BuiltInMetadata.PopulationSize.class);
        Double result = metadata.getPopulationSize(groupKey);
        return RelMetadataQuery.validateResult(result);
    }

    public static Double getAverageRowSize(RelNode rel) {
        BuiltInMetadata.Size metadata = rel.metadata(BuiltInMetadata.Size.class);
        return metadata.averageRowSize();
    }

    public static List<Double> getAverageColumnSizes(RelNode rel) {
        BuiltInMetadata.Size metadata = rel.metadata(BuiltInMetadata.Size.class);
        return metadata.averageColumnSizes();
    }

    public static List<Double> getAverageColumnSizesNotNull(RelNode rel) {
        BuiltInMetadata.Size metadata = rel.metadata(BuiltInMetadata.Size.class);
        List<Double> averageColumnSizes = metadata.averageColumnSizes();
        return averageColumnSizes == null ? Collections.nCopies(rel.getRowType().getFieldCount(), null) : averageColumnSizes;
    }

    public static Boolean isPhaseTransition(RelNode rel) {
        BuiltInMetadata.Parallelism metadata = rel.metadata(BuiltInMetadata.Parallelism.class);
        return metadata.isPhaseTransition();
    }

    public static Integer splitCount(RelNode rel) {
        BuiltInMetadata.Parallelism metadata = rel.metadata(BuiltInMetadata.Parallelism.class);
        return metadata.splitCount();
    }

    public static Double memory(RelNode rel) {
        BuiltInMetadata.Memory metadata = rel.metadata(BuiltInMetadata.Memory.class);
        return metadata.memory();
    }

    public static Double cumulativeMemoryWithinPhase(RelNode rel) {
        BuiltInMetadata.Memory metadata = rel.metadata(BuiltInMetadata.Memory.class);
        return metadata.cumulativeMemoryWithinPhase();
    }

    public static Double cumulativeMemoryWithinPhaseSplit(RelNode rel) {
        BuiltInMetadata.Memory metadata = rel.metadata(BuiltInMetadata.Memory.class);
        return metadata.cumulativeMemoryWithinPhaseSplit();
    }

    public static Double getDistinctRowCount(RelNode rel, ImmutableBitSet groupKey, RexNode predicate) {
        BuiltInMetadata.DistinctRowCount metadata = rel.metadata(BuiltInMetadata.DistinctRowCount.class);
        Double result = metadata.getDistinctRowCount(groupKey, predicate);
        return RelMetadataQuery.validateResult(result);
    }

    public static RelOptPredicateList getPulledUpPredicates(RelNode rel) {
        BuiltInMetadata.Predicates metadata = rel.metadata(BuiltInMetadata.Predicates.class);
        return metadata.getPredicates();
    }

    public static boolean isVisibleInExplain(RelNode rel, SqlExplainLevel explainLevel) {
        BuiltInMetadata.ExplainVisibility metadata = rel.metadata(BuiltInMetadata.ExplainVisibility.class);
        Boolean b = metadata.isVisibleInExplain(explainLevel);
        return b == null || b != false;
    }

    private static boolean isPercentage(Double result, boolean fail) {
        if (result != null) {
            double d = result;
            if (d < 0.0) {
                assert (!fail);
                return false;
            }
            if (d > 1.0) {
                assert (!fail);
                return false;
            }
        }
        return true;
    }

    private static boolean isNonNegative(Double result, boolean fail) {
        double d;
        if (result != null && (d = result.doubleValue()) < 0.0) {
            assert (!fail);
            return false;
        }
        return true;
    }

    private static Double validateResult(Double result) {
        if (result == null) {
            return null;
        }
        if (result.isInfinite()) {
            result = Double.MAX_VALUE;
        }
        assert (RelMetadataQuery.isNonNegative(result, true));
        if (result < 1.0) {
            result = 1.0;
        }
        return result;
    }
}

