/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Predicate;
import hive.org.apache.calcite.plan.hep.HepRelVertex;
import hive.org.apache.calcite.plan.volcano.RelSubset;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.Correlate;
import hive.org.apache.calcite.rel.core.Exchange;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.List;

public class RelMdColumnUniqueness {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.COLUMN_UNIQUENESS.method, new RelMdColumnUniqueness());
    private static final Predicate<RelNode> SAFE_REL = new Predicate<RelNode>(){

        @Override
        public boolean apply(RelNode r) {
            return r instanceof Aggregate || r instanceof Project;
        }
    };

    private RelMdColumnUniqueness() {
    }

    public Boolean areColumnsUnique(Filter rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Sort rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Exchange rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getInput(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Correlate rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Project rel, ImmutableBitSet columns, boolean ignoreNulls) {
        List<RexNode> projExprs = rel.getProjects();
        ImmutableBitSet.Builder childColumns = ImmutableBitSet.builder();
        for (int bit : columns) {
            RelDataType origType;
            RelDataTypeFactory typeFactory;
            RelDataType castType;
            RexNode castOperand;
            RexCall call;
            RexNode projExpr = projExprs.get(bit);
            if (projExpr instanceof RexInputRef) {
                childColumns.set(((RexInputRef)projExpr).getIndex());
                continue;
            }
            if (!(projExpr instanceof RexCall) || !ignoreNulls || (call = (RexCall)projExpr).getOperator() != SqlStdOperatorTable.CAST || !((castOperand = call.getOperands().get(0)) instanceof RexInputRef) || !(castType = (typeFactory = rel.getCluster().getTypeFactory()).createTypeWithNullability(projExpr.getType(), true)).equals(origType = typeFactory.createTypeWithNullability(castOperand.getType(), true))) continue;
            childColumns.set(((RexInputRef)castOperand).getIndex());
        }
        if (childColumns.cardinality() == 0) {
            return null;
        }
        return RelMetadataQuery.areColumnsUnique(rel.getInput(), childColumns.build(), ignoreNulls);
    }

    public Boolean areColumnsUnique(Join rel, ImmutableBitSet columns, boolean ignoreNulls) {
        if (columns.cardinality() == 0) {
            return false;
        }
        RelNode left = rel.getLeft();
        RelNode right = rel.getRight();
        ImmutableBitSet.Builder leftBuilder = ImmutableBitSet.builder();
        ImmutableBitSet.Builder rightBuilder = ImmutableBitSet.builder();
        int nLeftColumns = left.getRowType().getFieldCount();
        for (int bit : columns) {
            if (bit < nLeftColumns) {
                leftBuilder.set(bit);
                continue;
            }
            rightBuilder.set(bit - nLeftColumns);
        }
        ImmutableBitSet leftColumns = leftBuilder.build();
        Boolean leftUnique = RelMetadataQuery.areColumnsUnique(left, leftColumns, ignoreNulls);
        ImmutableBitSet rightColumns = rightBuilder.build();
        Boolean rightUnique = RelMetadataQuery.areColumnsUnique(right, rightColumns, ignoreNulls);
        if (leftColumns.cardinality() > 0 && rightColumns.cardinality() > 0) {
            if (leftUnique == null || rightUnique == null) {
                return null;
            }
            return leftUnique != false && rightUnique != false;
        }
        JoinInfo joinInfo = rel.analyzeCondition();
        if (leftColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnLeft()) {
                return false;
            }
            Boolean rightJoinColsUnique = RelMetadataQuery.areColumnsUnique(right, joinInfo.rightSet(), ignoreNulls);
            if (rightJoinColsUnique == null || leftUnique == null) {
                return null;
            }
            return rightJoinColsUnique != false && leftUnique != false;
        }
        if (rightColumns.cardinality() > 0) {
            if (rel.getJoinType().generatesNullsOnRight()) {
                return false;
            }
            Boolean leftJoinColsUnique = RelMetadataQuery.areColumnsUnique(left, joinInfo.leftSet(), ignoreNulls);
            if (leftJoinColsUnique == null || rightUnique == null) {
                return null;
            }
            return leftJoinColsUnique != false && rightUnique != false;
        }
        throw new AssertionError();
    }

    public Boolean areColumnsUnique(SemiJoin rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getLeft(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(Aggregate rel, ImmutableBitSet columns, boolean ignoreNulls) {
        ImmutableBitSet groupKey = ImmutableBitSet.range(rel.getGroupCount());
        return columns.contains(groupKey);
    }

    public Boolean areColumnsUnique(RelNode rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return null;
    }

    public Boolean areColumnsUnique(boolean dummy, HepRelVertex rel, ImmutableBitSet columns, boolean ignoreNulls) {
        return RelMetadataQuery.areColumnsUnique(rel.getCurrentRel(), columns, ignoreNulls);
    }

    public Boolean areColumnsUnique(boolean dummy, RelSubset rel, ImmutableBitSet columns, boolean ignoreNulls) {
        int nullCount = 0;
        for (RelNode rel2 : rel.getRels()) {
            if (!(rel2 instanceof Aggregate) && !this.simplyProjects(rel2, columns)) continue;
            Boolean unique = RelMetadataQuery.areColumnsUnique(rel2, columns, ignoreNulls);
            if (unique != null) {
                if (!unique.booleanValue()) continue;
                return true;
            }
            ++nullCount;
        }
        return nullCount == 0 ? Boolean.valueOf(false) : null;
    }

    private boolean simplyProjects(RelNode rel, ImmutableBitSet columns) {
        if (!(rel instanceof Project)) {
            return false;
        }
        Project project = (Project)rel;
        List<RexNode> projects = project.getProjects();
        for (int column : columns) {
            if (column >= projects.size()) {
                return false;
            }
            if (!(projects.get(column) instanceof RexInputRef)) {
                return false;
            }
            RexInputRef ref = (RexInputRef)projects.get(column);
            if (ref.getIndex() == column) continue;
            return false;
        }
        return true;
    }
}

