/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableNullableList;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.ReflectiveVisitor;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ReflectiveRelMetadataProvider
implements RelMetadataProvider,
ReflectiveVisitor {
    private final Map<Class<RelNode>, Function<RelNode, Metadata>> map;
    private final Class<?> metadataClass0;

    protected ReflectiveRelMetadataProvider(Map<Class<RelNode>, Function<RelNode, Metadata>> map, Class<?> metadataClass0) {
        assert (!map.isEmpty()) : "are your methods named wrong?";
        this.map = map;
        this.metadataClass0 = metadataClass0;
    }

    public static RelMetadataProvider reflectiveSource(Method method, Object target) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, ImmutableList.of(method));
    }

    public static RelMetadataProvider reflectiveSource(Object target, Method ... methods) {
        return ReflectiveRelMetadataProvider.reflectiveSource(target, ImmutableList.copyOf(methods));
    }

    /*
     * WARNING - void declaration
     */
    private static RelMetadataProvider reflectiveSource(final Object target, final ImmutableList<Method> methods) {
        void var8_10;
        assert (methods.size() > 0);
        Method method0 = (Method)methods.get(0);
        final Class<?> metadataClass0 = method0.getDeclaringClass();
        assert (Metadata.class.isAssignableFrom(metadataClass0));
        for (Method method : methods) {
            assert (method.getDeclaringClass() == metadataClass0);
        }
        HashSet<Class<?>> classes = Sets.newHashSet();
        HashMap<Pair<Class<RelNode>, Method>, Method> handlerMap = Maps.newHashMap();
        Method[] arr$ = target.getClass().getMethods();
        int len$ = arr$.length;
        boolean bl = false;
        while (var8_10 < len$) {
            Method handlerMethod = arr$[var8_10];
            for (Method method : methods) {
                if (!ReflectiveRelMetadataProvider.couldImplement(handlerMethod, method)) continue;
                Class<?> relNodeClass = handlerMethod.getParameterTypes()[0];
                classes.add(relNodeClass);
                handlerMap.put(Pair.of(relNodeClass, method), handlerMethod);
            }
            ++var8_10;
        }
        HashMap<Class<RelNode>, Function<RelNode, Metadata>> methodsMap = Maps.newHashMap();
        for (Class clazz : classes) {
            ImmutableNullableList.Builder<Method> builder = ImmutableNullableList.builder();
            for (Method method : methods) {
                builder.add(ReflectiveRelMetadataProvider.find(handlerMap, clazz, method));
            }
            final List handlerMethods = builder.build();
            Function<RelNode, Metadata> function = new Function<RelNode, Metadata>(){

                @Override
                public Metadata apply(final RelNode rel) {
                    return (Metadata)Proxy.newProxyInstance(metadataClass0.getClassLoader(), new Class[]{metadataClass0}, new InvocationHandler(){

                        @Override
                        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                            Object[] args1;
                            if (method.equals(BuiltInMethod.METADATA_REL.method)) {
                                return rel;
                            }
                            if (method.equals(BuiltInMethod.OBJECT_TO_STRING.method)) {
                                return metadataClass0.getSimpleName() + "(" + rel + ")";
                            }
                            int i = methods.indexOf(method);
                            if (i < 0) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            if (args == null) {
                                args1 = new Object[]{rel};
                            } else {
                                args1 = new Object[args.length + 1];
                                args1[0] = rel;
                                System.arraycopy(args, 0, args1, 1, args.length);
                            }
                            Method handlerMethod = (Method)handlerMethods.get(i);
                            if (handlerMethod == null) {
                                throw new AssertionError((Object)("not handled: " + method + " for " + rel));
                            }
                            return handlerMethod.invoke(target, args1);
                        }
                    });
                }
            };
            methodsMap.put(clazz, function);
        }
        return new ReflectiveRelMetadataProvider(methodsMap, metadataClass0);
    }

    private static Method find(Map<Pair<Class<RelNode>, Method>, Method> handlerMap, Class<RelNode> relNodeClass, Method method) {
        ArrayList<Class<RelNode>> newSources = Lists.newArrayList();
        while (relNodeClass != null) {
            Method implementingMethod = handlerMap.get(Pair.of(relNodeClass, method));
            if (implementingMethod != null) {
                return implementingMethod;
            }
            newSources.add(relNodeClass);
            for (Class<?> clazz : relNodeClass.getInterfaces()) {
                if (!RelNode.class.isAssignableFrom(clazz) || (implementingMethod = handlerMap.get(Pair.of(clazz, method))) == null) continue;
                return implementingMethod;
            }
            if (RelNode.class.isAssignableFrom(relNodeClass.getSuperclass())) {
                relNodeClass = relNodeClass.getSuperclass();
                continue;
            }
            relNodeClass = null;
        }
        return null;
    }

    private static boolean couldImplement(Method handlerMethod, Method method) {
        Class<?>[] parameterTypes;
        if (!handlerMethod.getName().equals(method.getName()) || (handlerMethod.getModifiers() & 8) != 0 || (handlerMethod.getModifiers() & 1) == 0) {
            return false;
        }
        Class<?>[] parameterTypes1 = handlerMethod.getParameterTypes();
        if (parameterTypes1.length != (parameterTypes = method.getParameterTypes()).length + 1 || !RelNode.class.isAssignableFrom(parameterTypes1[0])) {
            return false;
        }
        return Util.skip(Arrays.asList(parameterTypes1)).equals(Arrays.asList(parameterTypes));
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, Class<? extends Metadata> metadataClass) {
        if (metadataClass == this.metadataClass0) {
            return this.apply(relClass);
        }
        return null;
    }

    private synchronized Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass) {
        ArrayList<Class<? extends RelNode>> newSources = Lists.newArrayList();
        while (true) {
            Function<RelNode, Metadata> function;
            if ((function = this.map.get(relClass)) != null) {
                for (Class clazz : newSources) {
                    this.map.put(clazz, function);
                }
                return function;
            }
            newSources.add(relClass);
            for (Class<?> interfaceClass : relClass.getInterfaces()) {
                Function<RelNode, Metadata> function2;
                if (!RelNode.class.isAssignableFrom(interfaceClass) || (function2 = this.map.get(interfaceClass)) == null) continue;
                for (Class clazz : newSources) {
                    this.map.put(clazz, function2);
                }
                return function2;
            }
            if (!RelNode.class.isAssignableFrom(relClass.getSuperclass())) break;
            relClass = relClass.getSuperclass();
        }
        return null;
    }
}

