/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.metadata;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.Metadata;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class ChainedRelMetadataProvider
implements RelMetadataProvider {
    private final ImmutableList<RelMetadataProvider> providers;

    protected ChainedRelMetadataProvider(ImmutableList<RelMetadataProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Function<RelNode, Metadata> apply(Class<? extends RelNode> relClass, final Class<? extends Metadata> metadataClass) {
        final ArrayList<Function<RelNode, Metadata>> functions = Lists.newArrayList();
        for (RelMetadataProvider provider : this.providers) {
            Function<RelNode, Metadata> function = provider.apply(relClass, metadataClass);
            if (function == null) continue;
            functions.add(function);
        }
        switch (functions.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Function)functions.get(0);
            }
        }
        return new Function<RelNode, Metadata>(){

            @Override
            public Metadata apply(RelNode input) {
                ArrayList<Metadata> metadataList = Lists.newArrayList();
                for (Function function : functions) {
                    Metadata metadata = (Metadata)function.apply(input);
                    if (metadata == null) continue;
                    metadataList.add(metadata);
                }
                return (Metadata)Proxy.newProxyInstance(metadataClass.getClassLoader(), new Class[]{metadataClass}, (InvocationHandler)new ChainedInvocationHandler(metadataList));
            }
        };
    }

    public static RelMetadataProvider of(List<RelMetadataProvider> list) {
        return new ChainedRelMetadataProvider(ImmutableList.copyOf(list));
    }

    private static class ChainedInvocationHandler
    implements InvocationHandler {
        private final List<Metadata> metadataList;

        public ChainedInvocationHandler(List<Metadata> metadataList) {
            this.metadataList = ImmutableList.copyOf(metadataList);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            for (Metadata metadata : this.metadataList) {
                Object o = method.invoke((Object)metadata, args);
                if (o == null) continue;
                return o;
            }
            return null;
        }
    }
}

