/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.logical;

import hive.com.google.common.base.Supplier;
import hive.org.apache.calcite.plan.Convention;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelDistribution;
import hive.org.apache.calcite.rel.RelDistributionTraitDef;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Calc;
import hive.org.apache.calcite.rel.metadata.RelMdCollation;
import hive.org.apache.calcite.rel.metadata.RelMdDistribution;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.util.Util;
import java.util.List;
import java.util.Set;

public final class LogicalCalc
extends Calc {
    public LogicalCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program) {
        super(cluster, traitSet, child, program);
    }

    @Deprecated
    public LogicalCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, child, program);
        Util.discard(collationList);
    }

    public static LogicalCalc create(final RelNode input, final RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSet().replace(Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                return RelMdCollation.calc(input, program);
            }
        }).replaceIf(RelDistributionTraitDef.INSTANCE, new Supplier<RelDistribution>(){

            @Override
            public RelDistribution get() {
                return RelMdDistribution.calc(input, program);
            }
        });
        return new LogicalCalc(cluster, traitSet, input, program);
    }

    @Override
    public LogicalCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new LogicalCalc(this.getCluster(), traitSet, child, program);
    }

    @Override
    public void collectVariablesUsed(Set<String> variableSet) {
        RelOptUtil.VariableUsedVisitor vuv = new RelOptUtil.VariableUsedVisitor();
        for (RexNode expr : this.program.getExprList()) {
            expr.accept(vuv);
        }
        variableSet.addAll(vuv.variables);
    }
}

