/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.SetOp;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.sql.SqlKind;
import java.util.List;

public abstract class Union
extends SetOp {
    protected Union(RelOptCluster cluster, RelTraitSet traits, List<RelNode> inputs, boolean all) {
        super(cluster, traits, inputs, SqlKind.UNION, all);
    }

    protected Union(RelInput input) {
        super(input);
    }

    @Override
    public double getRows() {
        double dRows = Union.estimateRowCount(this);
        if (!this.all) {
            dRows *= 0.5;
        }
        return dRows;
    }

    public static double estimateRowCount(RelNode rel) {
        double dRows = 0.0;
        for (RelNode input : rel.getInputs()) {
            dRows += RelMetadataQuery.getRowCount(input).doubleValue();
        }
        return dRows;
    }
}

