/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.core;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelInput;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexChecker;
import hive.org.apache.calcite.rex.RexLocalRef;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgram;
import hive.org.apache.calcite.rex.RexShuttle;
import hive.org.apache.calcite.rex.RexUtil;
import java.util.List;

public abstract class Filter
extends SingleRel {
    protected final RexNode condition;

    protected Filter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, traits, child);
        assert (condition != null);
        assert (RexUtil.isFlat(condition)) : condition;
        this.condition = condition;
        assert (!CalcitePrepareImpl.DEBUG || this.isValid(true));
    }

    protected Filter(RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getExpression("condition"));
    }

    @Override
    public final RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return this.copy(traitSet, Filter.sole(inputs), this.getCondition());
    }

    public abstract Filter copy(RelTraitSet var1, RelNode var2, RexNode var3);

    @Override
    public List<RexNode> getChildExps() {
        return ImmutableList.of(this.condition);
    }

    @Override
    public RelNode accept(RexShuttle shuttle) {
        RexNode condition = shuttle.apply(this.condition);
        if (this.condition == condition) {
            return this;
        }
        return this.copy(this.traitSet, this.getInput(), condition);
    }

    public RexNode getCondition() {
        return this.condition;
    }

    @Override
    public boolean isValid(boolean fail) {
        RexChecker checker = new RexChecker(this.getInput().getRowType(), fail);
        this.condition.accept(checker);
        if (checker.getFailureCount() > 0) {
            assert (!fail);
            return false;
        }
        return true;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows = RelMetadataQuery.getRowCount(this);
        double dCpu = RelMetadataQuery.getRowCount(this.getInput());
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    @Override
    public double getRows() {
        return Filter.estimateFilteredRows(this.getInput(), this.condition);
    }

    public static double estimateFilteredRows(RelNode child, RexProgram program) {
        RexLocalRef programCondition = program.getCondition();
        RexNode condition = programCondition == null ? null : program.expandLocalRef(programCondition);
        return Filter.estimateFilteredRows(child, condition);
    }

    public static double estimateFilteredRows(RelNode child, RexNode condition) {
        return RelMetadataQuery.getRowCount(child) * RelMetadataQuery.getSelectivity(child, condition);
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("condition", this.condition);
    }
}

