/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.rel.convert;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitDef;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.SingleRel;
import hive.org.apache.calcite.rel.convert.Converter;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.util.Util;

public abstract class ConverterImpl
extends SingleRel
implements Converter {
    protected RelTraitSet inTraits;
    protected final RelTraitDef traitDef;

    protected ConverterImpl(RelOptCluster cluster, RelTraitDef traitDef, RelTraitSet traits, RelNode child) {
        super(cluster, traits, child);
        this.inTraits = child.getTraitSet();
        this.traitDef = traitDef;
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double dRows;
        double dCpu = dRows = RelMetadataQuery.getRowCount(this.getInput()).doubleValue();
        double dIo = 0.0;
        return planner.getCostFactory().makeCost(dRows, dCpu, dIo);
    }

    protected Error cannotImplement() {
        return Util.newInternal(this.getClass() + " cannot convert from " + this.inTraits + " traits");
    }

    @Override
    public boolean isDistinct() {
        return this.getInput().isDistinct();
    }

    @Override
    public RelTraitSet getInputTraits() {
        return this.inTraits;
    }

    @Override
    public RelTraitDef getTraitDef() {
        return this.traitDef;
    }
}

