/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan.volcano;

import hive.com.google.common.collect.Iterables;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.linq4j.function.Predicate1;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptListener;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.plan.volcano.RelSet;
import hive.org.apache.calcite.plan.volcano.VolcanoPlanner;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.RelWriter;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.trace.CalciteTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RelSubset
extends AbstractRelNode {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    RelOptCost bestCost;
    final RelSet set;
    RelNode best;
    long timestamp;
    boolean boosted;

    RelSubset(RelOptCluster cluster, RelSet set, RelTraitSet traits) {
        super(cluster, traits);
        this.set = set;
        this.boosted = false;
        assert (traits.allSimple());
        this.computeBestCost(cluster.getPlanner());
        this.recomputeDigest();
    }

    private void computeBestCost(RelOptPlanner planner) {
        this.bestCost = planner.getCostFactory().makeInfiniteCost();
        for (RelNode rel : this.getRels()) {
            RelOptCost cost = planner.getCost(rel);
            if (!cost.isLt(this.bestCost)) continue;
            this.bestCost = cost;
            this.best = rel;
        }
    }

    public Set<String> getVariablesSet() {
        return this.set.variablesPropagated;
    }

    public Set<String> getVariablesUsed() {
        return this.set.variablesUsed;
    }

    public RelNode getBest() {
        return this.best;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return planner.getCostFactory().makeZeroCost();
    }

    @Override
    public double getRows() {
        if (this.best != null) {
            return RelMetadataQuery.getRowCount(this.best);
        }
        return RelMetadataQuery.getRowCount(this.set.rel);
    }

    @Override
    public void explain(RelWriter pw) {
        String s = this.getDescription();
        pw.item("subset", s);
        AbstractRelNode input = Iterables.getFirst(this.getRels(), null);
        if (input == null) {
            return;
        }
        input.explainTerms(pw);
        pw.done(input);
    }

    @Override
    protected String computeDigest() {
        StringBuilder digest = new StringBuilder("Subset#");
        digest.append(this.set.id);
        for (RelTrait trait : this.traitSet) {
            digest.append('.').append(trait);
        }
        return digest.toString();
    }

    @Override
    protected RelDataType deriveRowType() {
        return this.set.rel.getRowType();
    }

    @Override
    public boolean isDistinct() {
        for (RelNode rel : this.set.rels) {
            if (!rel.isDistinct()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isKey(ImmutableBitSet columns) {
        for (RelNode rel : this.set.rels) {
            if (!rel.isKey(columns)) continue;
            return true;
        }
        return false;
    }

    Set<RelNode> getParents() {
        LinkedHashSet<RelNode> list = new LinkedHashSet<RelNode>();
        for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel.set != this.set || !rel.getTraitSet().equals(this.traitSet)) continue;
                list.add(parent);
            }
        }
        return list;
    }

    Set<RelSubset> getParentSubsets(VolcanoPlanner planner) {
        LinkedHashSet<RelSubset> list = new LinkedHashSet<RelSubset>();
        for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel.set != this.set || !rel.getTraitSet().equals(this.traitSet)) continue;
                list.add(planner.getSubset(parent));
            }
        }
        return list;
    }

    private static List<RelSubset> inputSubsets(RelNode parent) {
        return parent.getInputs();
    }

    public Collection<RelNode> getParentRels() {
        LinkedHashSet<RelNode> list = new LinkedHashSet<RelNode>();
        block0: for (RelNode parent : this.set.getParentRels()) {
            for (RelSubset rel : RelSubset.inputSubsets(parent)) {
                if (rel.set != this.set || !rel.getTraitSet().equals(this.traitSet)) continue;
                list.add(parent);
                continue block0;
            }
        }
        return list;
    }

    RelSet getSet() {
        return this.set;
    }

    void add(RelNode rel) {
        if (this.set.rels.contains(rel)) {
            return;
        }
        VolcanoPlanner planner = (VolcanoPlanner)rel.getCluster().getPlanner();
        if (planner.listener != null) {
            RelOptListener.RelEquivalenceEvent event = new RelOptListener.RelEquivalenceEvent(planner, rel, this, true);
            planner.listener.relEquivalenceFound(event);
        }
        if (this.set.rel != null && !RelOptUtil.equal("rowtype of new rel", rel.getRowType(), "rowtype of set", this.getRowType(), true)) {
            throw new AssertionError();
        }
        this.set.addInternal(rel);
        Set<String> variablesSet = RelOptUtil.getVariablesSet(rel);
        Set<String> variablesStopped = rel.getVariablesStopped();
    }

    RelNode buildCheapestPlan(VolcanoPlanner planner) {
        CheapestPlanReplacer replacer = new CheapestPlanReplacer(planner);
        RelNode cheapest = replacer.visit(this, -1, null);
        if (planner.listener != null) {
            RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(planner, null);
            planner.listener.relChosen(event);
        }
        return cheapest;
    }

    void propagateCostImprovements(VolcanoPlanner planner, RelNode rel, Set<RelSubset> activeSet) {
        for (RelSubset subset : this.set.subsets) {
            if (!rel.getTraitSet().satisfies(subset.traitSet)) continue;
            subset.propagateCostImprovements0(planner, rel, activeSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void propagateCostImprovements0(VolcanoPlanner planner, RelNode rel, Set<RelSubset> activeSet) {
        ++this.timestamp;
        if (!activeSet.add(this)) {
            LOGGER.finer("cyclic: " + this);
            return;
        }
        try {
            RelOptCost cost = planner.getCost(rel);
            if (cost.isLt(this.bestCost)) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Subset cost improved: subset [" + this + "] cost was " + this.bestCost + " now " + cost);
                }
                this.bestCost = cost;
                this.best = rel;
                planner.ruleQueue.recompute(this);
                for (RelNode parent : this.getParents()) {
                    RelSubset parentSubset = planner.getSubset(parent);
                    parentSubset.propagateCostImprovements(planner, parent, activeSet);
                }
                planner.checkForSatisfiedConverters(this.set, rel);
            }
        }
        finally {
            activeSet.remove(this);
        }
    }

    public void propagateBoostRemoval(VolcanoPlanner planner) {
        planner.ruleQueue.recompute(this);
        if (this.boosted) {
            this.boosted = false;
            for (RelSubset parentSubset : this.getParentSubsets(planner)) {
                parentSubset.propagateBoostRemoval(planner);
            }
        }
    }

    @Override
    public void collectVariablesUsed(Set<String> variableSet) {
        variableSet.addAll(this.getVariablesUsed());
    }

    @Override
    public void collectVariablesSet(Set<String> variableSet) {
        variableSet.addAll(this.getVariablesSet());
    }

    public Iterable<RelNode> getRels() {
        return new Iterable<RelNode>(){

            @Override
            public Iterator<RelNode> iterator() {
                return Linq4j.asEnumerable(RelSubset.this.set.rels).where((Predicate1)new Predicate1<RelNode>(){

                    public boolean apply(RelNode v1) {
                        return v1.getTraitSet().satisfies(RelSubset.this.traitSet);
                    }
                }).iterator();
            }
        };
    }

    public List<RelNode> getRelList() {
        ArrayList<RelNode> list = new ArrayList<RelNode>();
        for (RelNode rel : this.set.rels) {
            if (!rel.getTraitSet().satisfies(this.traitSet)) continue;
            list.add(rel);
        }
        return list;
    }

    static class CheapestPlanReplacer {
        VolcanoPlanner planner;

        CheapestPlanReplacer(VolcanoPlanner planner) {
            this.planner = planner;
        }

        public RelNode visit(RelNode p, int ordinal, RelNode parent) {
            if (p instanceof RelSubset) {
                RelSubset subset = (RelSubset)p;
                RelNode cheapest = subset.best;
                if (cheapest == null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    pw.println("Node [" + subset.getDescription() + "] could not be implemented; planner state:\n");
                    this.planner.dump(pw);
                    pw.flush();
                    String dump = sw.toString();
                    RelOptPlanner.CannotPlanException e = new RelOptPlanner.CannotPlanException(dump);
                    LOGGER.throwing(this.getClass().getName(), "visit", e);
                    throw e;
                }
                p = cheapest;
            }
            if (ordinal != -1 && this.planner.listener != null) {
                RelOptListener.RelChosenEvent event = new RelOptListener.RelChosenEvent(this.planner, p);
                this.planner.listener.relChosen(event);
            }
            List<RelNode> oldInputs = p.getInputs();
            ArrayList<RelNode> inputs = new ArrayList<RelNode>();
            for (int i = 0; i < oldInputs.size(); ++i) {
                RelNode oldInput = oldInputs.get(i);
                RelNode input = this.visit(oldInput, i, p);
                inputs.add(input);
            }
            if (!inputs.equals(oldInputs)) {
                RelNode pOld = p;
                p = p.copy(p.getTraitSet(), inputs);
                this.planner.provenanceMap.put(p, new VolcanoPlanner.DirectProvenance(pOld));
            }
            return p;
        }
    }
}

