/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.plan;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Equivalence;
import hive.com.google.common.base.Function;
import hive.com.google.common.base.Objects;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.base.Predicate;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableSet;
import hive.com.google.common.collect.LinkedHashMultimap;
import hive.com.google.common.collect.Lists;
import hive.com.google.common.collect.Maps;
import hive.com.google.common.collect.Multimap;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.avatica.util.Spaces;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.plan.RexImplicationChecker;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Aggregate;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.rel.core.Values;
import hive.org.apache.calcite.rel.logical.LogicalAggregate;
import hive.org.apache.calcite.rel.logical.LogicalFilter;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import hive.org.apache.calcite.rel.logical.LogicalProject;
import hive.org.apache.calcite.rel.logical.LogicalSort;
import hive.org.apache.calcite.rel.logical.LogicalUnion;
import hive.org.apache.calcite.rel.rules.ProjectRemoveRule;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexExecutorImpl;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexShuttle;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.validate.SqlValidatorUtil;
import hive.org.apache.calcite.util.ControlFlowException;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.IntList;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Util;
import hive.org.apache.calcite.util.mapping.Mapping;
import hive.org.apache.calcite.util.mapping.Mappings;
import hive.org.apache.calcite.util.trace.CalciteTrace;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SubstitutionVisitor {
    private static final boolean DEBUG = CalcitePrepareImpl.DEBUG;
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Equivalence<Object> STRING_EQUIVALENCE = new Equivalence<Object>(){

        @Override
        protected boolean doEquivalent(Object o, Object o2) {
            return o.toString().equals(o2.toString());
        }

        @Override
        protected int doHash(Object o) {
            return o.toString().hashCode();
        }
    };
    private static final Equivalence<List<?>> PAIRWISE_STRING_EQUIVALENCE = STRING_EQUIVALENCE.pairwise();
    protected static final ImmutableList<UnifyRule> DEFAULT_RULES = ImmutableList.of(ProjectToProjectUnifyRule.INSTANCE, FilterToProjectUnifyRule.INSTANCE, FilterToFilterUnifyRule.INSTANCE, AggregateToAggregateUnifyRule.INSTANCE, AggregateOnProjectToAggregateUnifyRule.INSTANCE);
    private final ImmutableList<UnifyRule> rules;
    private final Map<Pair<Class, Class>, List<UnifyRule>> ruleMap = new HashMap<Pair<Class, Class>, List<UnifyRule>>();
    private final RelOptCluster cluster;
    private final Holder query;
    private final MutableRel target;
    final List<MutableRel> targetLeaves;
    final List<MutableRel> queryLeaves;
    final Map<MutableRel, MutableRel> replacementMap = new HashMap<MutableRel, MutableRel>();
    final Multimap<MutableRel, MutableRel> equivalents = LinkedHashMultimap.create();
    protected final MutableRel[] slots = new MutableRel[2];

    public SubstitutionVisitor(RelNode target_, RelNode query_) {
        this(target_, query_, DEFAULT_RULES);
    }

    public SubstitutionVisitor(RelNode target_, RelNode query_, ImmutableList<UnifyRule> rules) {
        this.cluster = target_.getCluster();
        this.rules = rules;
        this.query = Holder.of(SubstitutionVisitor.toMutable(query_));
        this.target = SubstitutionVisitor.toMutable(target_);
        final Set parents = Sets.newIdentityHashSet();
        final ArrayList allNodes = new ArrayList();
        MutableRelVisitor visitor = new MutableRelVisitor(){

            @Override
            public void visit(MutableRel node) {
                parents.add(node.parent);
                allNodes.add(node);
                super.visit(node);
            }
        };
        visitor.go(this.target);
        allNodes.removeAll(parents);
        this.targetLeaves = ImmutableList.copyOf(allNodes);
        allNodes.clear();
        parents.clear();
        visitor.go(this.query);
        allNodes.removeAll(parents);
        this.queryLeaves = ImmutableList.copyOf(allNodes);
    }

    private static MutableRel toMutable(RelNode rel) {
        if (rel instanceof TableScan) {
            return MutableScan.of((TableScan)rel);
        }
        if (rel instanceof Values) {
            return MutableValues.of((Values)rel);
        }
        if (rel instanceof Project) {
            Project project = (Project)rel;
            MutableRel input = SubstitutionVisitor.toMutable(project.getInput());
            return MutableProject.of(input, project.getProjects(), project.getRowType().getFieldNames());
        }
        if (rel instanceof Filter) {
            Filter filter = (Filter)rel;
            MutableRel input = SubstitutionVisitor.toMutable(filter.getInput());
            return MutableFilter.of(input, filter.getCondition());
        }
        if (rel instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)rel;
            MutableRel input = SubstitutionVisitor.toMutable(aggregate.getInput());
            return MutableAggregate.of(input, aggregate.indicator, aggregate.getGroupSet(), aggregate.getGroupSets(), aggregate.getAggCallList());
        }
        if (rel instanceof Join) {
            Join join = (Join)rel;
            MutableRel left = SubstitutionVisitor.toMutable(join.getLeft());
            MutableRel right = SubstitutionVisitor.toMutable(join.getRight());
            return MutableJoin.of(join.getCluster(), left, right, join.getCondition(), join.getJoinType(), join.getVariablesStopped());
        }
        if (rel instanceof Sort) {
            Sort sort = (Sort)rel;
            MutableRel input = SubstitutionVisitor.toMutable(sort.getInput());
            return MutableSort.of(input, sort.getCollation(), sort.offset, sort.fetch);
        }
        throw new RuntimeException("cannot translate " + rel + " to MutableRel");
    }

    void register(MutableRel result, MutableRel query) {
    }

    @VisibleForTesting
    public static RexNode splitFilter(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        RexNode z = SubstitutionVisitor.splitOr(rexBuilder, condition, target);
        if (z != null) {
            return z;
        }
        RexNode x = RexUtil.andNot(rexBuilder, target, condition);
        if (SubstitutionVisitor.mayBeSatisfiable(x)) {
            RexNode x2 = RexUtil.andNot(rexBuilder, condition, target);
            return RexUtil.simplify(rexBuilder, x2);
        }
        return null;
    }

    private static RexNode splitOr(RexBuilder rexBuilder, RexNode condition, RexNode target) {
        List<RexNode> targets = RelOptUtil.disjunctions(target);
        for (RexNode e : RelOptUtil.disjunctions(condition)) {
            boolean found = RexUtil.removeAll(targets, e);
            if (found) continue;
            return null;
        }
        return RexUtil.composeConjunction(rexBuilder, Lists.transform(targets, RexUtil.notFn(rexBuilder)), false);
    }

    public static boolean mayBeSatisfiable(RexNode e) {
        ArrayList<RexNode> disjunctions = new ArrayList<RexNode>();
        ArrayList<RexNode> notDisjunctions = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(e, disjunctions, notDisjunctions);
        for (RexNode disjunction : disjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode disjunction : notDisjunctions) {
            switch (disjunction.getKind()) {
                case LITERAL: {
                    if (!RexLiteral.booleanValue(disjunction)) break;
                    return false;
                }
            }
        }
        for (RexNode notDisjunction : notDisjunctions) {
            List<RexNode> disjunctions2 = RelOptUtil.conjunctions(notDisjunction);
            if (!disjunctions.containsAll(disjunctions2)) continue;
            return false;
        }
        return true;
    }

    public RelNode go0(RelNode replacement_) {
        MutableRel node0;
        assert (false);
        MutableRel replacement = SubstitutionVisitor.toMutable(replacement_);
        assert (MutableRels.equalType("target", this.target, "replacement", replacement, true));
        this.replacementMap.put(this.target, replacement);
        UnifyResult unifyResult = this.matchRecurse(this.target);
        if (unifyResult == null) {
            return null;
        }
        MutableRel node = node0 = unifyResult.result;
        if (DEBUG) {
            System.out.println("Convert: query:\n" + this.query.deep() + "\nunify.query:\n" + ((UnifyResult)unifyResult).call.query.deep() + "\nunify.result:\n" + unifyResult.result.deep() + "\nunify.target:\n" + ((UnifyResult)unifyResult).call.target.deep() + "\nnode0:\n" + node0.deep() + "\nnode:\n" + node.deep());
        }
        return SubstitutionVisitor.fromMutable(node);
    }

    public RelNode go(RelNode replacement_) {
        int count;
        MutableRel replacement = SubstitutionVisitor.toMutable(replacement_);
        assert (MutableRels.equalType("target", this.target, "replacement", replacement, true));
        List queryDescendants = MutableRels.descendants(this.query);
        List targetDescendants = MutableRels.descendants(this.target);
        HashMap<MutableRel, MutableRel> map = Maps.newHashMap();
        for (MutableRel queryDescendant : queryDescendants) {
            map.put(queryDescendant, queryDescendant);
        }
        for (MutableRel targetDescendant : targetDescendants) {
            MutableRel queryDescendant = (MutableRel)map.get(targetDescendant);
            if (queryDescendant == null) continue;
            assert (queryDescendant.rowType.equals(targetDescendant.rowType));
            this.equivalents.put(queryDescendant, targetDescendant);
        }
        map.clear();
        block2: do {
            count = 0;
            for (MutableRel queryDescendant : queryDescendants) {
                for (MutableRel targetDescendant : targetDescendants) {
                    for (UnifyRule rule : this.applicableRules(queryDescendant, targetDescendant)) {
                        UnifyResult result;
                        UnifyRuleCall call = rule.match(this, queryDescendant, targetDescendant);
                        if (call == null || (result = rule.apply(call)) == null) continue;
                        ++count;
                        MutableRel parent = ((UnifyResult)result).call.query.replaceInParent(result.result);
                        for (int i = 0; i < rule.slotCount; ++i) {
                            this.equivalents.removeAll(this.slots[i]);
                        }
                        assert (((UnifyResult)result).result.rowType.equals(((UnifyResult)result).call.query.rowType)) : Pair.of(UnifyResult.access$100(result), UnifyResult.access$200((UnifyResult)result).query);
                        this.equivalents.put(result.result, ((UnifyResult)result).call.query);
                        if (targetDescendant != this.target) continue block2;
                        MutableRels.replace(this.query, this.target, replacement);
                        return SubstitutionVisitor.fromMutable(this.query.input);
                    }
                }
            }
        } while (count != 0);
        return null;
    }

    private static List<RelNode> fromMutables(List<MutableRel> nodes) {
        return Lists.transform(nodes, new Function<MutableRel, RelNode>(){

            @Override
            public RelNode apply(MutableRel mutableRel) {
                return SubstitutionVisitor.fromMutable(mutableRel);
            }
        });
    }

    private static RelNode fromMutable(MutableRel node) {
        switch (node.type) {
            case SCAN: 
            case VALUES: {
                return ((MutableLeafRel)node).rel;
            }
            case PROJECT: {
                MutableProject project = (MutableProject)node;
                return LogicalProject.create(SubstitutionVisitor.fromMutable(project.input), (List<? extends RexNode>)project.projects, project.rowType);
            }
            case FILTER: {
                MutableFilter filter = (MutableFilter)node;
                return LogicalFilter.create(SubstitutionVisitor.fromMutable(filter.input), filter.condition);
            }
            case AGGREGATE: {
                MutableAggregate aggregate = (MutableAggregate)node;
                return LogicalAggregate.create(SubstitutionVisitor.fromMutable(aggregate.input), aggregate.indicator, aggregate.groupSet, aggregate.groupSets, aggregate.aggCalls);
            }
            case SORT: {
                MutableSort sort = (MutableSort)node;
                return LogicalSort.create(SubstitutionVisitor.fromMutable(sort.input), sort.collation, sort.offset, sort.fetch);
            }
            case UNION: {
                MutableUnion union = (MutableUnion)node;
                return LogicalUnion.create(SubstitutionVisitor.fromMutables(union.inputs), union.all);
            }
            case JOIN: {
                MutableJoin join = (MutableJoin)node;
                return LogicalJoin.create(SubstitutionVisitor.fromMutable(join.getLeft()), SubstitutionVisitor.fromMutable(join.getRight()), join.getCondition(), join.getJoinType(), join.getVariablesStopped());
            }
        }
        throw new AssertionError((Object)node.deep());
    }

    private UnifyResult matchRecurse(MutableRel target) {
        assert (false);
        List<MutableRel> targetInputs = target.getInputs();
        MutableRel queryParent = null;
        for (MutableRel targetInput : targetInputs) {
            UnifyResult unifyResult = this.matchRecurse(targetInput);
            if (unifyResult == null) {
                return null;
            }
            queryParent = ((UnifyResult)unifyResult).call.query.replaceInParent(unifyResult.result);
        }
        if (targetInputs.isEmpty()) {
            for (MutableRel queryLeaf : this.queryLeaves) {
                for (UnifyRule rule : this.applicableRules(queryLeaf, target)) {
                    UnifyResult x = this.apply(rule, queryLeaf, target);
                    if (x == null) continue;
                    if (DEBUG) {
                        System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                    }
                    return x;
                }
            }
        } else {
            assert (queryParent != null);
            for (UnifyRule rule : this.applicableRules(queryParent, target)) {
                UnifyResult x = this.apply(rule, queryParent, target);
                if (x == null) continue;
                if (DEBUG) {
                    System.out.println("Rule: " + rule + "\nQuery:\n" + queryParent.deep() + (((UnifyResult)x).call.query != queryParent ? "\nQuery (original):\n" + queryParent.toString() : "") + "\nTarget:\n" + target.deep() + "\nResult:\n" + x.result.deep() + "\n");
                }
                return x;
            }
        }
        if (DEBUG) {
            System.out.println("Unify failed:\nQuery:\n" + queryParent.toString() + "\nTarget:\n" + target.toString() + "\n");
        }
        return null;
    }

    private UnifyResult apply(UnifyRule rule, MutableRel query, MutableRel target) {
        UnifyRuleCall call = new UnifyRuleCall(rule, query, target, null);
        return rule.apply(call);
    }

    private List<UnifyRule> applicableRules(MutableRel query, MutableRel target) {
        Class<?> targetClass;
        Class<?> queryClass = query.getClass();
        Pair<Class<?>, Class<?>> key = Pair.of(queryClass, targetClass = target.getClass());
        Collection<UnifyRule> list = this.ruleMap.get(key);
        if (list == null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (UnifyRule rule : this.rules) {
                if (!SubstitutionVisitor.mightMatch(rule, queryClass, targetClass)) continue;
                builder.add(rule);
            }
            list = builder.build();
            this.ruleMap.put((Pair<Class, Class>)key, (List<UnifyRule>)list);
        }
        return list;
    }

    private static boolean mightMatch(UnifyRule rule, Class queryClass, Class targetClass) {
        return rule.queryOperand.clazz.isAssignableFrom(queryClass) && rule.targetOperand.clazz.isAssignableFrom(targetClass);
    }

    public static MutableAggregate permute(MutableAggregate aggregate, MutableRel input, Mapping mapping) {
        ImmutableBitSet groupSet = Mappings.apply(mapping, aggregate.getGroupSet());
        ImmutableList<ImmutableBitSet> groupSets = Mappings.apply2(mapping, aggregate.getGroupSets());
        List<AggregateCall> aggregateCalls = SubstitutionVisitor.apply(mapping, aggregate.getAggCallList());
        return MutableAggregate.of(input, aggregate.indicator, groupSet, groupSets, aggregateCalls);
    }

    private static List<AggregateCall> apply(final Mapping mapping, List<AggregateCall> aggCallList) {
        return Lists.transform(aggCallList, new Function<AggregateCall, AggregateCall>(){

            @Override
            public AggregateCall apply(AggregateCall call) {
                return call.copy(Mappings.apply2(mapping, call.getArgList()), Mappings.apply((Mappings.TargetMapping)mapping, call.filterArg));
            }
        });
    }

    public static MutableRel unifyAggregates(MutableAggregate query, MutableAggregate target) {
        MutableRel result;
        if (query.getGroupType() != Aggregate.Group.SIMPLE || target.getGroupType() != Aggregate.Group.SIMPLE) {
            throw new AssertionError(false);
        }
        if (query.getGroupSet().equals(target.getGroupSet())) {
            ArrayList<Integer> projects = Lists.newArrayList();
            int groupCount = query.getGroupSet().cardinality();
            for (int i = 0; i < groupCount; ++i) {
                projects.add(i);
            }
            for (AggregateCall aggregateCall : query.getAggCallList()) {
                int i = target.getAggCallList().indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                projects.add(groupCount + i);
            }
            result = MutableRels.createProject(target, projects);
        } else {
            ImmutableBitSet.Builder groupSet = ImmutableBitSet.builder();
            IntList targetGroupList = target.getGroupSet().toList();
            for (int c : query.getGroupSet()) {
                int c2 = targetGroupList.indexOf(c);
                if (c2 < 0) {
                    return null;
                }
                groupSet.set(c2);
            }
            ArrayList<AggregateCall> aggregateCalls = Lists.newArrayList();
            for (AggregateCall aggregateCall : query.getAggCallList()) {
                if (aggregateCall.isDistinct()) {
                    return null;
                }
                int i = target.getAggCallList().indexOf(aggregateCall);
                if (i < 0) {
                    return null;
                }
                aggregateCalls.add(AggregateCall.create(SubstitutionVisitor.getRollup(aggregateCall.getAggregation()), aggregateCall.isDistinct(), ImmutableList.of(Integer.valueOf(target.groupSet.cardinality() + i)), -1, aggregateCall.type, aggregateCall.name));
            }
            result = MutableAggregate.of(target, false, groupSet.build(), null, aggregateCalls);
        }
        return MutableRels.createCastRel(result, query.getRowType(), true);
    }

    public static SqlAggFunction getRollup(SqlAggFunction aggregation) {
        if (aggregation == SqlStdOperatorTable.SUM || aggregation == SqlStdOperatorTable.MIN || aggregation == SqlStdOperatorTable.MAX || aggregation == SqlStdOperatorTable.SUM0) {
            return aggregation;
        }
        if (aggregation == SqlStdOperatorTable.COUNT) {
            return SqlStdOperatorTable.SUM0;
        }
        return null;
    }

    protected static RexShuttle getRexShuttle(MutableProject target) {
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (RexNode e : target.getProjects()) {
            map.put(e.toString(), map.size());
        }
        return new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                Integer integer = (Integer)map.get(ref.getName());
                if (integer != null) {
                    return new RexInputRef(integer, ref.getType());
                }
                throw MatchFailed.INSTANCE;
            }

            @Override
            public RexNode visitCall(RexCall call) {
                Integer integer = (Integer)map.get(call.toString());
                if (integer != null) {
                    return new RexInputRef(integer, call.getType());
                }
                return super.visitCall(call);
            }
        };
    }

    public static class FilterOnProjectRule
    extends RelOptRule {
        private static final Predicate<LogicalFilter> PREDICATE = new Predicate<LogicalFilter>(){

            @Override
            public boolean apply(LogicalFilter input) {
                return input.getCondition() instanceof RexInputRef;
            }
        };
        public static final FilterOnProjectRule INSTANCE = new FilterOnProjectRule();

        private FilterOnProjectRule() {
            super(FilterOnProjectRule.operand(LogicalFilter.class, null, PREDICATE, FilterOnProjectRule.some(FilterOnProjectRule.operand(LogicalProject.class, FilterOnProjectRule.any()), new RelOptRuleOperand[0])));
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            LogicalProject project = (LogicalProject)call.rel(1);
            ArrayList<RexNode> newProjects = new ArrayList<RexNode>(project.getProjects());
            newProjects.add(filter.getCondition());
            RelOptCluster cluster = filter.getCluster();
            RelDataType newRowType = cluster.getTypeFactory().builder().addAll(project.getRowType().getFieldList()).add("condition", Util.last(newProjects).getType()).build();
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newProjects, newRowType);
            RexInputRef newCondition = cluster.getRexBuilder().makeInputRef(newProject, newProjects.size() - 1);
            call.transformTo(LogicalFilter.create(newProject, newCondition));
        }
    }

    private static class SlotCounter {
        int queryCount;
        int targetCount;

        private SlotCounter() {
        }

        void visit(Operand operand) {
            if (operand instanceof QueryOperand) {
                ++this.queryCount;
            } else if (operand instanceof TargetOperand) {
                ++this.targetCount;
            } else if (!(operand instanceof AnyOperand)) {
                for (Operand input : ((InternalOperand)operand).inputs) {
                    this.visit(input);
                }
            }
        }
    }

    private static class TargetOperand
    extends Operand {
        private final int ordinal;

        protected TargetOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            return rel0 == rel || visitor.equivalents.get(rel0).contains(rel);
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            MutableRel relinput;
            MutableRel rel0 = visitor.slots[this.ordinal];
            assert (rel0 != null) : "QueryOperand should have been called first";
            if (rel0 == rel || visitor.equivalents.get(rel0).contains(rel)) {
                return false;
            }
            if (!(rel0 instanceof MutableFilter) || !(rel instanceof MutableFilter)) {
                return false;
            }
            if (!rel.getRowType().equals(rel0.getRowType())) {
                return false;
            }
            MutableRel rel0input = ((MutableFilter)rel0).getInput();
            if (rel0input != (relinput = ((MutableFilter)rel).getInput()) && !visitor.equivalents.get(rel0input).contains(relinput)) {
                return false;
            }
            RexExecutorImpl rexImpl = (RexExecutorImpl)rel.cluster.getPlanner().getExecutor();
            RexImplicationChecker rexImplicationChecker = new RexImplicationChecker(rel.cluster.getRexBuilder(), rexImpl, rel.getRowType());
            return rexImplicationChecker.implies(((MutableFilter)rel0).getCondition(), ((MutableFilter)rel).getCondition());
        }
    }

    private static class QueryOperand
    extends Operand {
        private final int ordinal;

        protected QueryOperand(int ordinal) {
            super(MutableRel.class);
            this.ordinal = ordinal;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            visitor.slots[this.ordinal] = rel;
            return true;
        }
    }

    private static class AnyOperand
    extends Operand {
        AnyOperand(Class<? extends MutableRel> clazz) {
            super(clazz);
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel);
        }
    }

    private static class InternalOperand
    extends Operand {
        private final List<Operand> inputs;

        InternalOperand(Class<? extends MutableRel> clazz, List<Operand> inputs) {
            super(clazz);
            this.inputs = inputs;
        }

        @Override
        public boolean matches(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allMatch(visitor, this.inputs, rel.getInputs());
        }

        @Override
        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return this.clazz.isInstance(rel) && InternalOperand.allWeaker(visitor, this.inputs, rel.getInputs());
        }

        private static boolean allMatch(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).matches(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }

        private static boolean allWeaker(SubstitutionVisitor visitor, List<Operand> operands, List<MutableRel> rels) {
            if (operands.size() != rels.size()) {
                return false;
            }
            for (Pair<Operand, MutableRel> pair : Pair.zip(operands, rels)) {
                if (((Operand)pair.left).isWeaker(visitor, (MutableRel)pair.right)) continue;
                return false;
            }
            return true;
        }
    }

    protected static abstract class Operand {
        protected final Class<? extends MutableRel> clazz;

        protected Operand(Class<? extends MutableRel> clazz) {
            this.clazz = clazz;
        }

        public abstract boolean matches(SubstitutionVisitor var1, MutableRel var2);

        public boolean isWeaker(SubstitutionVisitor visitor, MutableRel rel) {
            return false;
        }
    }

    protected static class MutableRelDumper
    extends MutableRelVisitor {
        private final StringBuilder buf = new StringBuilder();
        private int level;

        protected MutableRelDumper() {
        }

        @Override
        public void visit(MutableRel node) {
            Spaces.append(this.buf, this.level * 2);
            if (node == null) {
                this.buf.append("null");
            } else {
                node.digest(this.buf);
                this.buf.append("\n");
                ++this.level;
                super.visit(node);
                --this.level;
            }
        }

        public String apply(MutableRel rel) {
            this.go(rel);
            return this.buf.toString();
        }
    }

    protected static class MutableRels {
        protected MutableRels() {
        }

        public static boolean contains(MutableRel ancestor, final MutableRel target) {
            if (ancestor.equals(target)) {
                return true;
            }
            try {
                new MutableRelVisitor(){

                    @Override
                    public void visit(MutableRel node) {
                        if (node.equals(target)) {
                            throw Util.FoundOne.NULL;
                        }
                        super.visit(node);
                    }
                }.go(ancestor);
                return false;
            }
            catch (Util.FoundOne e) {
                return true;
            }
        }

        private static List<MutableRel> descendants(MutableRel query) {
            ArrayList<MutableRel> list = new ArrayList<MutableRel>();
            MutableRels.descendantsRecurse(list, query);
            return list;
        }

        private static void descendantsRecurse(List<MutableRel> list, MutableRel rel) {
            list.add(rel);
            for (MutableRel input : rel.getInputs()) {
                MutableRels.descendantsRecurse(list, input);
            }
        }

        public static boolean equalType(String desc0, MutableRel rel0, String desc1, MutableRel rel1, boolean fail) {
            return RelOptUtil.equal(desc0, rel0.getRowType(), desc1, rel1.getRowType(), fail);
        }

        public static void replace(MutableRel query, MutableRel find, MutableRel replace) {
            if (find.equals(replace)) {
                return;
            }
            assert (MutableRels.equalType("find", find, "replace", replace, true));
            MutableRels.replaceRecurse(query, find, replace);
        }

        private static void replaceRecurse(MutableRel query, MutableRel find, MutableRel replace) {
            List<MutableRel> inputs = query.getInputs();
            for (int i = 0; i < inputs.size(); ++i) {
                MutableRel input = inputs.get(i);
                if (input.equals(find)) {
                    query.setInput(i, replace);
                    continue;
                }
                MutableRels.replaceRecurse(input, find, replace);
            }
        }

        public static MutableRel strip(MutableProject project) {
            return MutableRels.isTrivial(project) ? project.getInput() : project;
        }

        public static boolean isTrivial(MutableProject project) {
            MutableRel child = project.getInput();
            RelDataType childRowType = child.getRowType();
            return ProjectRemoveRule.isIdentity(project.getProjects(), childRowType);
        }

        public static MutableRel createProject(MutableRel child, final List<Integer> posList) {
            final RelDataType rowType = child.getRowType();
            if (Mappings.isIdentity(posList, rowType.getFieldCount())) {
                return child;
            }
            return MutableProject.of(RelOptUtil.permute(child.cluster.getTypeFactory(), rowType, Mappings.bijection(posList)), child, (List<RexNode>)new AbstractList<RexNode>(){

                @Override
                public int size() {
                    return posList.size();
                }

                @Override
                public RexNode get(int index) {
                    int pos = (Integer)posList.get(index);
                    return RexInputRef.of(pos, rowType);
                }
            });
        }

        public static MutableRel createCastRel(MutableRel rel, RelDataType castRowType, boolean rename) {
            RelDataType rowType = rel.getRowType();
            if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
                return rel;
            }
            List<RexNode> castExps = RexUtil.generateCastExpressions(rel.cluster.getRexBuilder(), castRowType, rowType);
            List<String> fieldNames = rename ? castRowType.getFieldNames() : rowType.getFieldNames();
            return MutableProject.of(rel, castExps, fieldNames);
        }
    }

    private static class MutableJoin
    extends MutableBiRel {
        protected final RexNode condition;
        protected final ImmutableSet<String> variablesStopped;
        protected JoinRelType joinType;

        private MutableJoin(RelDataType rowType, MutableRel left, MutableRel right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
            super(MutableRelType.JOIN, left.cluster, rowType, left, right);
            this.condition = Preconditions.checkNotNull(condition);
            this.variablesStopped = ImmutableSet.copyOf(variablesStopped);
            this.joinType = Preconditions.checkNotNull(joinType);
        }

        public RexNode getCondition() {
            return this.condition;
        }

        public JoinRelType getJoinType() {
            return this.joinType;
        }

        public ImmutableSet getVariablesStopped() {
            return this.variablesStopped;
        }

        static MutableJoin of(RelOptCluster cluster, MutableRel left, MutableRel right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) {
            List<RelDataTypeField> fieldList = Collections.emptyList();
            RelDataType rowType = Join.deriveJoinRowType(left.getRowType(), right.getRowType(), joinType, cluster.getTypeFactory(), null, fieldList);
            return new MutableJoin(rowType, left, right, condition, joinType, variablesStopped);
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Join(left: ").append(this.left).append(", right:").append(this.right).append(")");
        }
    }

    private static abstract class MutableBiRel
    extends MutableRel {
        protected MutableRel left;
        protected MutableRel right;

        MutableBiRel(MutableRelType type, RelOptCluster cluster, RelDataType rowType, MutableRel left, MutableRel right) {
            super(cluster, rowType, type);
            this.left = left;
            left.parent = this;
            left.ordinalInParent = 0;
            this.right = right;
            right.parent = this;
            right.ordinalInParent = 1;
        }

        @Override
        public void setInput(int ordinalInParent, MutableRel input) {
            if (ordinalInParent > 1) {
                throw new IllegalArgumentException();
            }
            if (ordinalInParent == 0) {
                this.left = input;
            } else {
                this.right = input;
            }
            if (input != null) {
                input.parent = this;
                input.ordinalInParent = 0;
            }
        }

        @Override
        public List<MutableRel> getInputs() {
            return ImmutableList.of(this.left, this.right);
        }

        public MutableRel getLeft() {
            return this.left;
        }

        public MutableRel getRight() {
            return this.right;
        }

        @Override
        public void childrenAccept(MutableRelVisitor visitor) {
            visitor.visit(this.left);
            visitor.visit(this.right);
        }
    }

    protected static class MutableUnion
    extends MutableSetOp {
        public boolean all;

        private MutableUnion(RelOptCluster cluster, RelDataType rowType, List<MutableRel> inputs, boolean all) {
            super(cluster, rowType, MutableRelType.UNION, inputs);
            this.all = all;
        }

        static MutableUnion of(List<MutableRel> inputs, boolean all) {
            assert (inputs.size() >= 2);
            MutableRel input0 = inputs.get(0);
            return new MutableUnion(input0.cluster, input0.rowType, inputs, all);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableUnion && this.inputs.equals(((MutableUnion)obj).getInputs());
        }

        public int hashCode() {
            return Objects.hashCode(new Object[]{this.type, this.inputs});
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Union");
        }
    }

    protected static abstract class MutableSetOp
    extends MutableRel {
        protected final List<MutableRel> inputs;

        private MutableSetOp(RelOptCluster cluster, RelDataType rowType, MutableRelType type, List<MutableRel> inputs) {
            super(cluster, rowType, type);
            this.inputs = inputs;
        }

        @Override
        public void setInput(int ordinalInParent, MutableRel input) {
            this.inputs.set(ordinalInParent, input);
        }

        @Override
        public List<MutableRel> getInputs() {
            return this.inputs;
        }

        @Override
        public void childrenAccept(MutableRelVisitor visitor) {
            for (MutableRel input : this.inputs) {
                visitor.visit(input);
            }
        }
    }

    protected static class MutableSort
    extends MutableSingleRel {
        private final RelCollation collation;
        private final RexNode offset;
        private final RexNode fetch;

        private MutableSort(MutableRel input, RelCollation collation, RexNode offset, RexNode fetch) {
            super(MutableRelType.SORT, input.rowType, input);
            this.collation = collation;
            this.offset = offset;
            this.fetch = fetch;
        }

        static MutableSort of(MutableRel input, RelCollation collation, RexNode offset, RexNode fetch) {
            return new MutableSort(input, collation, offset, fetch);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableSort && this.collation.equals(((MutableSort)obj).collation) && Objects.equal(this.offset, ((MutableSort)obj).offset) && Objects.equal(this.fetch, ((MutableSort)obj).fetch) && this.input.equals(((MutableSort)obj).input);
        }

        public int hashCode() {
            return Objects.hashCode(this.input, this.collation, this.offset, this.fetch);
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            buf.append("Sort(collation: ").append(this.collation);
            if (this.offset != null) {
                buf.append(", offset: ").append(this.offset);
            }
            if (this.fetch != null) {
                buf.append(", fetch: ").append(this.fetch);
            }
            return buf.append(")");
        }
    }

    protected static class MutableAggregate
    extends MutableSingleRel {
        public final boolean indicator;
        private final ImmutableBitSet groupSet;
        private final ImmutableList<ImmutableBitSet> groupSets;
        private final List<AggregateCall> aggCalls;

        private MutableAggregate(MutableRel input, RelDataType rowType, boolean indicator, ImmutableBitSet groupSet, List<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            super(MutableRelType.AGGREGATE, rowType, input);
            this.indicator = indicator;
            this.groupSet = groupSet;
            this.groupSets = groupSets == null ? ImmutableList.of(groupSet) : ImmutableList.copyOf(groupSets);
            this.aggCalls = aggCalls;
        }

        static MutableAggregate of(MutableRel input, boolean indicator, ImmutableBitSet groupSet, ImmutableList<ImmutableBitSet> groupSets, List<AggregateCall> aggCalls) {
            RelDataType rowType = Aggregate.deriveRowType(input.cluster.getTypeFactory(), input.getRowType(), indicator, groupSet, groupSets, aggCalls);
            return new MutableAggregate(input, rowType, indicator, groupSet, groupSets, aggCalls);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableAggregate && this.groupSet.equals(((MutableAggregate)obj).groupSet) && this.aggCalls.equals(((MutableAggregate)obj).aggCalls) && this.input.equals(((MutableAggregate)obj).input);
        }

        public int hashCode() {
            return Objects.hashCode(this.input, this.groupSet, this.aggCalls);
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Aggregate(groupSet: ").append(this.groupSet).append(", groupSets: ").append(this.groupSets).append(", calls: ").append(this.aggCalls).append(")");
        }

        public ImmutableBitSet getGroupSet() {
            return this.groupSet;
        }

        public ImmutableList<ImmutableBitSet> getGroupSets() {
            return this.groupSets;
        }

        public List<AggregateCall> getAggCallList() {
            return this.aggCalls;
        }

        public Aggregate.Group getGroupType() {
            return Aggregate.Group.induce(this.groupSet, this.groupSets);
        }
    }

    protected static class MutableFilter
    extends MutableSingleRel {
        private final RexNode condition;

        private MutableFilter(MutableRel input, RexNode condition) {
            super(MutableRelType.FILTER, input.rowType, input);
            this.condition = condition;
        }

        public static MutableFilter of(MutableRel input, RexNode condition) {
            return new MutableFilter(input, condition);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableFilter && this.condition.toString().equals(((MutableFilter)obj).condition.toString()) && this.input.equals(((MutableFilter)obj).input);
        }

        public int hashCode() {
            return Objects.hashCode(this.input, this.condition.toString());
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Filter(condition: ").append(this.condition).append(")");
        }

        public RexNode getCondition() {
            return this.condition;
        }
    }

    protected static class MutableProject
    extends MutableSingleRel {
        private final List<RexNode> projects;

        private MutableProject(RelDataType rowType, MutableRel input, List<RexNode> projects) {
            super(MutableRelType.PROJECT, rowType, input);
            this.projects = projects;
            assert (RexUtil.compatibleTypes(projects, rowType, true));
        }

        public static MutableProject of(RelDataType rowType, MutableRel input, List<RexNode> projects) {
            return new MutableProject(rowType, input, projects);
        }

        public static MutableRel of(MutableRel child, List<RexNode> exprList, List<String> fieldNameList) {
            RelDataType rowType = RexUtil.createStructType(child.cluster.getTypeFactory(), exprList, fieldNameList == null ? null : SqlValidatorUtil.uniquify(fieldNameList, SqlValidatorUtil.F_SUGGESTER));
            return MutableProject.of(rowType, child, exprList);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableProject && PAIRWISE_STRING_EQUIVALENCE.equivalent(this.projects, ((MutableProject)obj).projects) && this.input.equals(((MutableProject)obj).input);
        }

        public int hashCode() {
            return Objects.hashCode(this.input, PAIRWISE_STRING_EQUIVALENCE.hash(this.projects));
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Project(projects: ").append(this.projects).append(")");
        }

        public List<RexNode> getProjects() {
            return this.projects;
        }

        public final List<Pair<RexNode, String>> getNamedProjects() {
            return Pair.zip(this.getProjects(), this.getRowType().getFieldNames());
        }

        public Mappings.TargetMapping getMapping() {
            return Project.getMapping(this.input.getRowType().getFieldCount(), this.projects);
        }
    }

    protected static class MutableValues
    extends MutableLeafRel {
        private MutableValues(Values rel) {
            super(MutableRelType.VALUES, rel);
        }

        static MutableValues of(Values rel) {
            return new MutableValues(rel);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableValues && this.rel == ((MutableValues)obj).rel;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Values(tuples: ").append(((Values)this.rel).getTuples()).append(")");
        }
    }

    protected static class MutableScan
    extends MutableLeafRel {
        private MutableScan(TableScan rel) {
            super(MutableRelType.SCAN, rel);
        }

        static MutableScan of(TableScan rel) {
            return new MutableScan(rel);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MutableScan && this.rel == ((MutableScan)obj).rel;
        }

        public int hashCode() {
            return this.rel.hashCode();
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Scan(table: ").append(this.rel.getTable().getQualifiedName()).append(")");
        }
    }

    protected static abstract class MutableSingleRel
    extends MutableRel {
        protected MutableRel input;

        MutableSingleRel(MutableRelType type, RelDataType rowType, MutableRel input) {
            super(input.cluster, rowType, type);
            this.input = input;
            input.parent = this;
            input.ordinalInParent = 0;
        }

        @Override
        public void setInput(int ordinalInParent, MutableRel input) {
            if (ordinalInParent >= 1) {
                throw new IllegalArgumentException();
            }
            this.input = input;
            if (input != null) {
                input.parent = this;
                input.ordinalInParent = 0;
            }
        }

        @Override
        public List<MutableRel> getInputs() {
            return ImmutableList.of(this.input);
        }

        @Override
        public void childrenAccept(MutableRelVisitor visitor) {
            visitor.visit(this.input);
        }

        public MutableRel getInput() {
            return this.input;
        }
    }

    protected static abstract class MutableLeafRel
    extends MutableRel {
        protected final RelNode rel;

        MutableLeafRel(MutableRelType type, RelNode rel) {
            super(rel.getCluster(), rel.getRowType(), type);
            this.rel = rel;
        }

        @Override
        public void setInput(int ordinalInParent, MutableRel input) {
            throw new IllegalArgumentException();
        }

        @Override
        public List<MutableRel> getInputs() {
            return ImmutableList.of();
        }

        @Override
        public void childrenAccept(MutableRelVisitor visitor) {
        }
    }

    private static class Holder
    extends MutableSingleRel {
        private Holder(MutableRelType type, RelDataType rowType, MutableRel input) {
            super(type, rowType, input);
        }

        static Holder of(MutableRel input) {
            return new Holder(MutableRelType.HOLDER, input.rowType, input);
        }

        @Override
        public StringBuilder digest(StringBuilder buf) {
            return buf.append("Holder");
        }
    }

    protected static abstract class MutableRel {
        MutableRel parent;
        int ordinalInParent;
        public final RelOptCluster cluster;
        final RelDataType rowType;
        final MutableRelType type;

        private MutableRel(RelOptCluster cluster, RelDataType rowType, MutableRelType type) {
            this.cluster = cluster;
            this.rowType = rowType;
            this.type = type;
        }

        public RelDataType getRowType() {
            return this.rowType;
        }

        public abstract void setInput(int var1, MutableRel var2);

        public abstract List<MutableRel> getInputs();

        public abstract void childrenAccept(MutableRelVisitor var1);

        public MutableRel replaceInParent(MutableRel child) {
            MutableRel parent = this.parent;
            if (this != child && parent != null) {
                parent.setInput(this.ordinalInParent, child);
                this.parent = null;
                this.ordinalInParent = 0;
            }
            return parent;
        }

        public abstract StringBuilder digest(StringBuilder var1);

        public final String deep() {
            return new MutableRelDumper().apply(this);
        }

        public final String toString() {
            return this.deep();
        }

        public MutableRel getParent() {
            return this.parent;
        }
    }

    private static class MutableRelVisitor {
        private MutableRel root;

        private MutableRelVisitor() {
        }

        public void visit(MutableRel node) {
            node.childrenAccept(this);
        }

        public MutableRel go(MutableRel p) {
            this.root = p;
            this.visit(p);
            return this.root;
        }
    }

    private static enum MutableRelType {
        SCAN,
        PROJECT,
        FILTER,
        AGGREGATE,
        SORT,
        UNION,
        JOIN,
        HOLDER,
        VALUES;

    }

    private static class AggregateOnProjectToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateOnProjectToAggregateUnifyRule INSTANCE = new AggregateOnProjectToAggregateUnifyRule();

        private AggregateOnProjectToAggregateUnifyRule() {
            super(AggregateOnProjectToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnProjectToAggregateUnifyRule.operand(MutableProject.class, AggregateOnProjectToAggregateUnifyRule.query(0))), AggregateOnProjectToAggregateUnifyRule.operand(MutableAggregate.class, AggregateOnProjectToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableAggregate target = (MutableAggregate)call.target;
            if (!(query.getInput() instanceof MutableProject)) {
                return null;
            }
            MutableProject project = (MutableProject)query.getInput();
            if (project.getInput() != target.getInput()) {
                return null;
            }
            Mappings.TargetMapping mapping = project.getMapping();
            if (mapping == null) {
                return null;
            }
            MutableAggregate aggregate2 = SubstitutionVisitor.permute(query, project.getInput(), mapping.inverse());
            MutableRel result = SubstitutionVisitor.unifyAggregates(aggregate2, target);
            return result == null ? null : call.result(result);
        }
    }

    private static class AggregateToAggregateUnifyRule
    extends AbstractUnifyRule {
        public static final AggregateToAggregateUnifyRule INSTANCE = new AggregateToAggregateUnifyRule();

        private AggregateToAggregateUnifyRule() {
            super(AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.query(0)), AggregateToAggregateUnifyRule.operand(MutableAggregate.class, AggregateToAggregateUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableAggregate query = (MutableAggregate)call.query;
            MutableAggregate target = (MutableAggregate)call.target;
            assert (query != target);
            if (!target.getGroupSet().contains(query.getGroupSet())) {
                return null;
            }
            MutableRel result = SubstitutionVisitor.unifyAggregates(query, target);
            if (result == null) {
                return null;
            }
            return call.result(result);
        }
    }

    private static class ProjectToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToFilterUnifyRule INSTANCE = new ProjectToFilterUnifyRule();

        private ProjectToFilterUnifyRule() {
            super(ProjectToFilterUnifyRule.operand(MutableProject.class, ProjectToFilterUnifyRule.query(0)), ProjectToFilterUnifyRule.operand(MutableFilter.class, ProjectToFilterUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query.parent instanceof MutableFilter) {
                UnifyRuleCall in2 = call.create(call.query.parent);
                MutableFilter query = (MutableFilter)in2.query;
                MutableFilter target = (MutableFilter)in2.target;
                MutableFilter newFilter = FilterToFilterUnifyRule.INSTANCE.createFilter(query, target);
                if (newFilter == null) {
                    return null;
                }
                return in2.result(query.replaceInParent(newFilter));
            }
            return null;
        }
    }

    private static class FilterToFilterUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToFilterUnifyRule INSTANCE = new FilterToFilterUnifyRule();

        private FilterToFilterUnifyRule() {
            super(FilterToFilterUnifyRule.operand(MutableFilter.class, FilterToFilterUnifyRule.query(0)), FilterToFilterUnifyRule.operand(MutableFilter.class, FilterToFilterUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            MutableFilter query = (MutableFilter)call.query;
            MutableFilter target = (MutableFilter)call.target;
            MutableFilter newFilter = this.createFilter(query, target);
            if (newFilter == null) {
                return null;
            }
            return call.result(newFilter);
        }

        MutableFilter createFilter(MutableFilter query, MutableFilter target) {
            RexNode newCondition = SubstitutionVisitor.splitFilter(query.cluster.getRexBuilder(), query.getCondition(), target.getCondition());
            if (newCondition == null) {
                return null;
            }
            if (newCondition.isAlwaysTrue()) {
                return target;
            }
            return MutableFilter.of(target, newCondition);
        }
    }

    private static class FilterToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final FilterToProjectUnifyRule INSTANCE = new FilterToProjectUnifyRule();

        private FilterToProjectUnifyRule() {
            super(FilterToProjectUnifyRule.operand(MutableFilter.class, FilterToProjectUnifyRule.query(0)), FilterToProjectUnifyRule.operand(MutableProject.class, FilterToProjectUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            try {
                RexNode newCondition;
                MutableProject target = (MutableProject)call.target;
                RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
                MutableFilter query = (MutableFilter)call.query;
                try {
                    newCondition = query.getCondition().accept(shuttle);
                }
                catch (MatchFailed e) {
                    return null;
                }
                MutableFilter newFilter = MutableFilter.of(target, newCondition);
                if (query.parent instanceof MutableProject) {
                    MutableRel inverse = this.invert(((MutableProject)query.parent).getNamedProjects(), (MutableRel)newFilter, shuttle);
                    return call.create(query.parent).result(inverse);
                }
                MutableRel inverse = this.invert(query, (MutableRel)newFilter, target);
                return call.result(inverse);
            }
            catch (MatchFailed e) {
                return null;
            }
        }

        protected MutableRel invert(List<Pair<RexNode, String>> namedProjects, MutableRel input, RexShuttle shuttle) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("SubstitutionVisitor: invert:\nprojects: " + namedProjects + "\n" + "input: " + input + "\n" + "project: " + shuttle + "\n");
            }
            ArrayList<RexNode> exprList = new ArrayList<RexNode>();
            RexBuilder rexBuilder = input.cluster.getRexBuilder();
            List<RexNode> projects = Pair.left(namedProjects);
            for (RexNode expr : projects) {
                exprList.add(rexBuilder.makeZeroLiteral(expr.getType()));
            }
            for (RexNode expr : Ord.zip(projects)) {
                RexNode node = ((RexNode)((Ord)expr).e).accept(shuttle);
                if (node == null) {
                    throw MatchFailed.INSTANCE;
                }
                exprList.set(((Ord)expr).i, node);
            }
            return MutableProject.of(input, exprList, Pair.right(namedProjects));
        }

        protected MutableRel invert(MutableRel model, MutableRel input, MutableProject project) {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("SubstitutionVisitor: invert:\nmodel: " + model + "\n" + "input: " + input + "\n" + "project: " + project + "\n");
            }
            ArrayList<RexNode> exprList = new ArrayList<RexNode>();
            RexBuilder rexBuilder = model.cluster.getRexBuilder();
            for (RelDataTypeField field : model.getRowType().getFieldList()) {
                exprList.add(rexBuilder.makeZeroLiteral(field.getType()));
            }
            for (Ord expr : Ord.zip(project.getProjects())) {
                if (expr.e instanceof RexInputRef) {
                    int target = ((RexInputRef)expr.e).getIndex();
                    exprList.set(expr.i, rexBuilder.ensureType(((RexNode)expr.e).getType(), RexInputRef.of(target, input.rowType), false));
                    continue;
                }
                throw MatchFailed.INSTANCE;
            }
            return MutableProject.of(model.rowType, input, exprList);
        }
    }

    private static class ProjectToProjectUnifyRule
    extends AbstractUnifyRule {
        public static final ProjectToProjectUnifyRule INSTANCE = new ProjectToProjectUnifyRule();

        private ProjectToProjectUnifyRule() {
            super(ProjectToProjectUnifyRule.operand(MutableProject.class, ProjectToProjectUnifyRule.query(0)), ProjectToProjectUnifyRule.operand(MutableProject.class, ProjectToProjectUnifyRule.target(0)), 1);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            List<RexNode> newProjects;
            MutableProject target = (MutableProject)call.target;
            MutableProject query = (MutableProject)call.query;
            RexShuttle shuttle = SubstitutionVisitor.getRexShuttle(target);
            try {
                newProjects = shuttle.apply(query.getProjects());
            }
            catch (MatchFailed e) {
                return null;
            }
            MutableProject newProject = MutableProject.of(query.getRowType(), target, newProjects);
            MutableRel newProject2 = MutableRels.strip(newProject);
            return call.result(newProject2);
        }
    }

    private static class TrivialRule
    extends AbstractUnifyRule {
        private static final TrivialRule INSTANCE = new TrivialRule();

        private TrivialRule() {
            super(TrivialRule.any(MutableRel.class), TrivialRule.any(MutableRel.class), 0);
        }

        @Override
        public UnifyResult apply(UnifyRuleCall call) {
            if (call.query.equals(call.target)) {
                return call.result(call.query);
            }
            return null;
        }
    }

    protected static abstract class AbstractUnifyRule
    extends UnifyRule {
        public AbstractUnifyRule(Operand queryOperand, Operand targetOperand, int slotCount) {
            super(slotCount, queryOperand, targetOperand);
            assert (this.isValid());
        }

        protected boolean isValid() {
            SlotCounter slotCounter = new SlotCounter();
            slotCounter.visit(this.queryOperand);
            assert (slotCounter.queryCount == this.slotCount);
            assert (slotCounter.targetCount == 0);
            slotCounter.queryCount = 0;
            slotCounter.visit(this.targetOperand);
            assert (slotCounter.queryCount == 0);
            assert (slotCounter.targetCount == this.slotCount);
            return true;
        }

        protected static Operand operand(Class<? extends MutableRel> clazz, Operand ... inputOperands) {
            return new InternalOperand(clazz, ImmutableList.copyOf(inputOperands));
        }

        protected static Operand any(Class<? extends MutableRel> clazz) {
            return new AnyOperand(clazz);
        }

        protected static Operand query(int ordinal) {
            return new QueryOperand(ordinal);
        }

        protected static Operand target(int ordinal) {
            return new TargetOperand(ordinal);
        }
    }

    protected static class UnifyResult {
        private final UnifyRuleCall call;
        private final MutableRel result;

        UnifyResult(UnifyRuleCall call, MutableRel result) {
            this.call = call;
            assert (MutableRels.equalType("query", call.query, "result", result, true));
            this.result = result;
        }
    }

    protected class UnifyRuleCall {
        protected final UnifyRule rule;
        public final MutableRel query;
        public final MutableRel target;
        protected final ImmutableList<MutableRel> slots;

        public UnifyRuleCall(UnifyRule rule, MutableRel query, MutableRel target, ImmutableList<MutableRel> slots) {
            this.rule = Preconditions.checkNotNull(rule);
            this.query = Preconditions.checkNotNull(query);
            this.target = Preconditions.checkNotNull(target);
            this.slots = Preconditions.checkNotNull(slots);
        }

        public UnifyResult result(MutableRel result) {
            assert (MutableRels.contains(result, this.target));
            assert (MutableRels.equalType("result", result, "query", this.query, true));
            MutableRel replace = SubstitutionVisitor.this.replacementMap.get(this.target);
            if (replace != null) {
                assert (false);
                MutableRels.replace(result, this.target, replace);
            }
            SubstitutionVisitor.this.register(result, this.query);
            return new UnifyResult(this, result);
        }

        public UnifyRuleCall create(MutableRel query) {
            return new UnifyRuleCall(this.rule, query, this.target, this.slots);
        }

        public RelOptCluster getCluster() {
            return SubstitutionVisitor.this.cluster;
        }
    }

    protected static abstract class UnifyRule {
        protected final int slotCount;
        protected final Operand queryOperand;
        protected final Operand targetOperand;

        protected UnifyRule(int slotCount, Operand queryOperand, Operand targetOperand) {
            this.slotCount = slotCount;
            this.queryOperand = queryOperand;
            this.targetOperand = targetOperand;
        }

        protected abstract UnifyResult apply(UnifyRuleCall var1);

        protected UnifyRuleCall match(SubstitutionVisitor visitor, MutableRel query, MutableRel target) {
            if (this.queryOperand.matches(visitor, query) && this.targetOperand.matches(visitor, target)) {
                SubstitutionVisitor substitutionVisitor = visitor;
                substitutionVisitor.getClass();
                return substitutionVisitor.new UnifyRuleCall(this, query, target, this.copy(visitor.slots, this.slotCount));
            }
            return null;
        }

        protected <E> ImmutableList<E> copy(E[] slots, int slotCount) {
            switch (slotCount) {
                case 0: {
                    return ImmutableList.of();
                }
                case 1: {
                    return ImmutableList.of(slots[0]);
                }
            }
            return ImmutableList.copyOf(slots).subList(0, slotCount);
        }
    }

    protected static class MatchFailed
    extends ControlFlowException {
        public static final MatchFailed INSTANCE = new MatchFailed();

        protected MatchFailed() {
        }
    }
}

