/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.materialize;

import hive.com.google.common.base.Throwables;
import hive.com.google.common.cache.CacheBuilder;
import hive.com.google.common.cache.CacheLoader;
import hive.com.google.common.cache.LoadingCache;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.materialize.LatticeStatisticProvider;
import hive.org.apache.calcite.util.Pair;
import java.util.concurrent.ExecutionException;

class CachingLatticeStatisticProvider
implements LatticeStatisticProvider {
    private final LoadingCache<Pair<Lattice, Lattice.Column>, Integer> cache;

    public CachingLatticeStatisticProvider(final LatticeStatisticProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(new CacheLoader<Pair<Lattice, Lattice.Column>, Integer>(){

            @Override
            public Integer load(Pair<Lattice, Lattice.Column> key) throws Exception {
                return provider.cardinality((Lattice)key.left, (Lattice.Column)key.right);
            }
        });
    }

    @Override
    public int cardinality(Lattice lattice, Lattice.Column column) {
        try {
            return this.cache.get(Pair.of(lattice, column));
        }
        catch (ExecutionException e) {
            throw Throwables.propagate(e);
        }
    }
}

