/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import hive.com.google.common.base.Preconditions;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.jdbc.CalciteRootSchema;
import hive.org.apache.calcite.materialize.Lattice;
import hive.org.apache.calcite.schema.Function;
import hive.org.apache.calcite.schema.Schema;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.schema.Table;
import java.util.Collection;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;

public interface CalciteSchema {
    public CalciteSchema getParent();

    public CalciteRootSchema root();

    public String getName();

    public SchemaPlus plus();

    public Schema getSchema();

    public List<? extends List<String>> getPath();

    public List<String> path(String var1);

    public TableEntry add(String var1, Table var2, ImmutableList<String> var3);

    public TableEntry add(String var1, Table var2);

    public CalciteSchema add(String var1, Schema var2);

    public FunctionEntry add(String var1, Function var2);

    public LatticeEntry add(String var1, Lattice var2);

    public TableEntry getTableBySql(String var1);

    public TableEntry getTable(String var1, boolean var2);

    public CalciteSchema getSubSchema(String var1, boolean var2);

    public NavigableMap<String, CalciteSchema> getSubSchemaMap();

    public NavigableMap<String, LatticeEntry> getLatticeMap();

    public NavigableSet<String> getTableNames();

    public Collection<Function> getFunctions(String var1, boolean var2);

    public NavigableSet<String> getFunctionNames();

    public NavigableMap<String, Table> getTablesBasedOnNullaryFunctions();

    public TableEntry getTableBasedOnNullaryFunction(String var1, boolean var2);

    public void setCache(boolean var1);

    public boolean isCacheEnabled();

    public static abstract class LatticeEntry
    extends Entry {
        public LatticeEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Lattice getLattice();

        public abstract TableEntry getStarTable();
    }

    public static abstract class FunctionEntry
    extends Entry {
        public FunctionEntry(CalciteSchema schema, String name) {
            super(schema, name);
        }

        public abstract Function getFunction();

        public abstract boolean isMaterialization();
    }

    public static abstract class TableEntry
    extends Entry {
        public final List<String> sqls;

        public TableEntry(CalciteSchema schema, String name, ImmutableList<String> sqls) {
            super(schema, name);
            this.sqls = Preconditions.checkNotNull(sqls);
        }

        public abstract Table getTable();
    }

    public static abstract class Entry {
        public final CalciteSchema schema;
        public final String name;

        public Entry(CalciteSchema schema, String name) {
            this.schema = Preconditions.checkNotNull(schema);
            this.name = Preconditions.checkNotNull(name);
        }

        public final List<String> path() {
            return this.schema.path(this.name);
        }
    }
}

