/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.jdbc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.avatica.AvaticaParameter;
import hive.org.apache.calcite.avatica.ColumnMetaData;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.config.CalciteConnectionConfig;
import hive.org.apache.calcite.jdbc.CalciteRootSchema;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.EnumerableDefaults;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.linq4j.function.Function0;
import hive.org.apache.calcite.linq4j.tree.ClassDeclaration;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.prepare.CalcitePrepareImpl;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.runtime.ArrayBindable;
import hive.org.apache.calcite.runtime.Bindable;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.validate.SqlValidator;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Stacks;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface CalcitePrepare {
    public static final Function0<CalcitePrepare> DEFAULT_FACTORY = new Function0<CalcitePrepare>(){

        public CalcitePrepare apply() {
            return new CalcitePrepareImpl();
        }
    };
    public static final ThreadLocal<ArrayList<Context>> THREAD_CONTEXT_STACK = new ThreadLocal<ArrayList<Context>>(){

        @Override
        protected ArrayList<Context> initialValue() {
            return new ArrayList<Context>();
        }
    };

    public ParseResult parse(Context var1, String var2);

    public ConvertResult convert(Context var1, String var2);

    public AnalyzeViewResult analyzeView(Context var1, String var2, boolean var3);

    public <T> CalciteSignature<T> prepareSql(Context var1, String var2, Queryable<T> var3, Type var4, long var5);

    public <T> CalciteSignature<T> prepareQueryable(Context var1, Queryable<T> var2);

    public static class CalciteSignature<T>
    extends Meta.Signature {
        @JsonIgnore
        public final RelDataType rowType;
        private final long maxRowCount;
        private final Bindable<T> bindable;

        public CalciteSignature(String sql, List<AvaticaParameter> parameterList, Map<String, Object> internalParameters, RelDataType rowType, List<ColumnMetaData> columns, Meta.CursorFactory cursorFactory, long maxRowCount, Bindable<T> bindable) {
            super(columns, sql, parameterList, internalParameters, cursorFactory);
            this.rowType = rowType;
            this.maxRowCount = maxRowCount;
            this.bindable = bindable;
        }

        public Enumerable<T> enumerable(DataContext dataContext) {
            Enumerable enumerable = this.bindable.bind(dataContext);
            if (this.maxRowCount >= 0L) {
                enumerable = EnumerableDefaults.take(enumerable, (long)this.maxRowCount);
            }
            return enumerable;
        }
    }

    public static class AnalyzeViewResult
    extends ConvertResult {
        public final Table table;
        public final ImmutableList<String> tablePath;
        public final RexNode constraint;
        public final ImmutableIntList columnMapping;

        public AnalyzeViewResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelNode relNode, Table table, ImmutableList<String> tablePath, RexNode constraint, ImmutableIntList columnMapping) {
            super(prepare, validator, sql, sqlNode, rowType, relNode);
            this.table = table;
            this.tablePath = tablePath;
            this.constraint = constraint;
            this.columnMapping = columnMapping;
        }
    }

    public static class ConvertResult
    extends ParseResult {
        public final RelNode relNode;

        public ConvertResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType, RelNode relNode) {
            super(prepare, validator, sql, sqlNode, rowType);
            this.relNode = relNode;
        }
    }

    public static class ParseResult {
        public final CalcitePrepareImpl prepare;
        public final String sql;
        public final SqlNode sqlNode;
        public final RelDataType rowType;
        public final RelDataTypeFactory typeFactory;

        public ParseResult(CalcitePrepareImpl prepare, SqlValidator validator, String sql, SqlNode sqlNode, RelDataType rowType) {
            this.prepare = prepare;
            this.sql = sql;
            this.sqlNode = sqlNode;
            this.rowType = rowType;
            this.typeFactory = validator.getTypeFactory();
        }
    }

    public static class Dummy {
        private static SparkHandler sparkHandler;

        private Dummy() {
        }

        public static synchronized SparkHandler getSparkHandler(boolean enable) {
            if (sparkHandler == null) {
                sparkHandler = enable ? Dummy.createHandler() : new TrivialSparkHandler();
            }
            return sparkHandler;
        }

        private static SparkHandler createHandler() {
            try {
                Class<?> clazz = Class.forName("hive.org.apache.calcite.adapter.spark.SparkHandlerImpl");
                Method method = clazz.getMethod("instance", new Class[0]);
                return (SparkHandler)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException e) {
                return new TrivialSparkHandler();
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public static void push(Context context) {
            Stacks.push((List)THREAD_CONTEXT_STACK.get(), context);
        }

        public static Context peek() {
            return (Context)Stacks.peek((List)THREAD_CONTEXT_STACK.get());
        }

        public static void pop(Context context) {
            Stacks.pop((List)THREAD_CONTEXT_STACK.get(), context);
        }

        private static class TrivialSparkHandler
        implements SparkHandler {
            private TrivialSparkHandler() {
            }

            @Override
            public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
                return rootRel;
            }

            @Override
            public void registerRules(SparkHandler.RuleSetBuilder builder) {
            }

            @Override
            public boolean enabled() {
                return false;
            }

            @Override
            public ArrayBindable compile(ClassDeclaration expr, String s) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Object sparkContext() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface SparkHandler {
        public RelNode flattenTypes(RelOptPlanner var1, RelNode var2, boolean var3);

        public void registerRules(RuleSetBuilder var1);

        public boolean enabled();

        public ArrayBindable compile(ClassDeclaration var1, String var2);

        public Object sparkContext();

        public static interface RuleSetBuilder {
            public void addRule(RelOptRule var1);

            public void removeRule(RelOptRule var1);
        }
    }

    public static interface Context {
        public JavaTypeFactory getTypeFactory();

        public CalciteRootSchema getRootSchema();

        public List<String> getDefaultSchemaPath();

        public CalciteConnectionConfig config();

        public SparkHandler spark();

        public DataContext getDataContext();
    }
}

