/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica.remote;

import hive.org.apache.calcite.avatica.AvaticaConnection;
import hive.org.apache.calcite.avatica.BuiltInConnectionProperty;
import hive.org.apache.calcite.avatica.ConnectionConfig;
import hive.org.apache.calcite.avatica.ConnectionProperty;
import hive.org.apache.calcite.avatica.DriverVersion;
import hive.org.apache.calcite.avatica.Meta;
import hive.org.apache.calcite.avatica.UnregisteredDriver;
import hive.org.apache.calcite.avatica.remote.AvaticaRemoteConnectionProperty;
import hive.org.apache.calcite.avatica.remote.MockJsonService;
import hive.org.apache.calcite.avatica.remote.RemoteMeta;
import hive.org.apache.calcite.avatica.remote.RemoteService;
import hive.org.apache.calcite.avatica.remote.Service;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class Driver
extends UnregisteredDriver {
    public static final String CONNECT_STRING_PREFIX = "jdbc:avatica:remote:";

    @Override
    protected String getConnectStringPrefix() {
        return CONNECT_STRING_PREFIX;
    }

    @Override
    protected DriverVersion createDriverVersion() {
        return DriverVersion.load(Driver.class, "org-apache-calcite-jdbc.properties", "Avatica Remote JDBC Driver", "unknown version", "Avatica", "unknown version");
    }

    @Override
    protected Collection<ConnectionProperty> getConnectionProperties() {
        ArrayList<ConnectionProperty> list = new ArrayList<ConnectionProperty>();
        Collections.addAll(list, BuiltInConnectionProperty.values());
        Collections.addAll(list, AvaticaRemoteConnectionProperty.values());
        return list;
    }

    @Override
    public Meta createMeta(AvaticaConnection connection) {
        Service service;
        ConnectionConfig config = connection.config();
        Service.Factory metaFactory = config.factory();
        if (metaFactory != null) {
            service = metaFactory.create(connection);
        } else if (config.url() != null) {
            URL url;
            try {
                url = new URL(config.url());
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            service = new RemoteService(url);
        } else {
            service = new MockJsonService(Collections.emptyMap());
        }
        return new RemoteMeta(connection, service);
    }

    static {
        new Driver().register();
    }
}

