/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.avatica;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import hive.org.apache.calcite.avatica.Meta;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionPropertiesImpl
implements Meta.ConnectionProperties {
    private boolean isDirty = false;
    private Boolean autoCommit;
    private Boolean readOnly;
    private Integer transactionIsolation;
    private String catalog;
    private String schema;

    public ConnectionPropertiesImpl() {
    }

    public ConnectionPropertiesImpl(Connection conn) throws SQLException {
        this(conn.getAutoCommit(), conn.isReadOnly(), conn.getTransactionIsolation(), conn.getCatalog(), conn.getSchema());
    }

    @JsonCreator
    public ConnectionPropertiesImpl(@JsonProperty(value="autoCommit") Boolean autoCommit, @JsonProperty(value="readOnly") Boolean readOnly, @JsonProperty(value="transactionIsolation") Integer transactionIsolation, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema) {
        this.autoCommit = autoCommit;
        this.readOnly = readOnly;
        this.transactionIsolation = transactionIsolation;
        this.catalog = catalog;
        this.schema = schema;
    }

    public ConnectionPropertiesImpl setDirty(boolean val) {
        this.isDirty = val;
        return this;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean isEmpty() {
        return this.autoCommit == null && this.readOnly == null && this.transactionIsolation == null && this.catalog == null && this.schema == null;
    }

    @Override
    public ConnectionPropertiesImpl merge(Meta.ConnectionProperties that) {
        if (this == that) {
            return this;
        }
        if (that.isAutoCommit() != null && this.autoCommit != that.isAutoCommit()) {
            this.autoCommit = that.isAutoCommit();
            this.isDirty = true;
        }
        if (that.isReadOnly() != null && this.readOnly != that.isReadOnly()) {
            this.readOnly = that.isReadOnly();
            this.isDirty = true;
        }
        if (that.getTransactionIsolation() != null && !that.getTransactionIsolation().equals(this.transactionIsolation)) {
            this.transactionIsolation = that.getTransactionIsolation();
            this.isDirty = true;
        }
        if (that.getCatalog() != null && !that.getCatalog().equalsIgnoreCase(this.catalog)) {
            this.catalog = that.getCatalog();
            this.isDirty = true;
        }
        if (that.getSchema() != null && !that.getSchema().equalsIgnoreCase(this.schema)) {
            this.schema = that.getSchema();
            this.isDirty = true;
        }
        return this;
    }

    @Override
    public Meta.ConnectionProperties setAutoCommit(boolean val) {
        this.autoCommit = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isAutoCommit() {
        return this.autoCommit;
    }

    @Override
    public Meta.ConnectionProperties setReadOnly(boolean val) {
        this.readOnly = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public Meta.ConnectionProperties setTransactionIsolation(int val) {
        this.transactionIsolation = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public Integer getTransactionIsolation() {
        return this.transactionIsolation;
    }

    @Override
    public Meta.ConnectionProperties setCatalog(String val) {
        this.catalog = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public Meta.ConnectionProperties setSchema(String val) {
        this.schema = val;
        this.isDirty = true;
        return this;
    }

    @Override
    public String getSchema() {
        return this.schema;
    }
}

