/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.AggAddContext;
import hive.org.apache.calcite.adapter.enumerable.AggContext;
import hive.org.apache.calcite.adapter.enumerable.AggImplementor;
import hive.org.apache.calcite.adapter.enumerable.AggResetContext;
import hive.org.apache.calcite.adapter.enumerable.AggResultContext;
import hive.org.apache.calcite.adapter.enumerable.RexImpTable;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.adapter.enumerable.WinAggContext;
import hive.org.apache.calcite.adapter.enumerable.WinAggResultContext;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.Node;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Primitive;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rex.RexNode;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public abstract class StrictAggImplementor
implements AggImplementor {
    private boolean needTrackEmptySet;
    private boolean trackNullsPerRow;
    private int stateSize;

    protected boolean nonDefaultOnEmptySet(AggContext info) {
        return info.returnRelType().isNullable();
    }

    protected final int getStateSize() {
        return this.stateSize;
    }

    protected final void accAdvance(AggAddContext add, Expression acc, Expression next) {
        add.currentBlock().add(Expressions.statement((Expression)Expressions.assign((Expression)acc, (Expression)Types.castIfNecessary((Type)acc.type, (Expression)next))));
    }

    @Override
    public final List<Type> getStateType(AggContext info) {
        List<Type> subState = this.getNotNullState(info);
        this.stateSize = subState.size();
        this.needTrackEmptySet = this.nonDefaultOnEmptySet(info);
        if (!this.needTrackEmptySet) {
            return subState;
        }
        boolean hasNullableArgs = false;
        for (RelDataType relDataType : info.parameterRelTypes()) {
            if (!relDataType.isNullable()) continue;
            hasNullableArgs = true;
            break;
        }
        this.trackNullsPerRow = !(info instanceof WinAggContext) || hasNullableArgs;
        ArrayList<Type> res = new ArrayList<Type>(subState.size() + 1);
        res.addAll(subState);
        res.add(Boolean.TYPE);
        return res;
    }

    public List<Type> getNotNullState(AggContext info) {
        return Collections.singletonList(Primitive.unbox((Type)info.returnType()));
    }

    @Override
    public final void implementReset(AggContext info, AggResetContext reset) {
        if (this.trackNullsPerRow) {
            List<Expression> acc = reset.accumulator();
            Expression flag = acc.get(acc.size() - 1);
            BlockBuilder block = reset.currentBlock();
            block.add(Expressions.statement((Expression)Expressions.assign((Expression)flag, (Expression)RexImpTable.getDefaultValue(flag.getType()))));
        }
        this.implementNotNullReset(info, reset);
    }

    protected void implementNotNullReset(AggContext info, AggResetContext reset) {
        BlockBuilder block = reset.currentBlock();
        List<Expression> accumulator = reset.accumulator();
        for (int i = 0; i < this.getStateSize(); ++i) {
            Expression exp = accumulator.get(i);
            block.add(Expressions.statement((Expression)Expressions.assign((Expression)exp, (Expression)RexImpTable.getDefaultValue(exp.getType()))));
        }
    }

    @Override
    public final void implementAdd(AggContext info, AggAddContext add) {
        BlockBuilder thenBlock;
        List<RexNode> args = add.rexArguments();
        RexToLixTranslator translator = add.rowTranslator();
        ArrayList<Expression> conditions = new ArrayList<Expression>();
        conditions.addAll(translator.translateList(args, RexImpTable.NullAs.IS_NOT_NULL));
        if (add.rexFilterArgument() != null) {
            conditions.add(translator.translate(add.rexFilterArgument(), RexImpTable.NullAs.FALSE));
        }
        Expression condition = Expressions.foldAnd(conditions);
        if (Expressions.constant((Object)false).equals((Object)condition)) {
            return;
        }
        boolean argsNotNull = Expressions.constant((Object)true).equals((Object)condition);
        BlockBuilder blockBuilder = thenBlock = argsNotNull ? add.currentBlock() : new BlockBuilder(true, add.currentBlock());
        if (this.trackNullsPerRow) {
            List<Expression> acc = add.accumulator();
            thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)acc.get(acc.size() - 1), (Expression)Expressions.constant((Object)true))));
        }
        if (argsNotNull) {
            this.implementNotNullAdd(info, add);
            return;
        }
        HashMap<RexNode, Boolean> nullables = new HashMap<RexNode, Boolean>();
        for (RexNode arg : args) {
            if (!translator.isNullable(arg)) continue;
            nullables.put(arg, false);
        }
        add.nestBlock(thenBlock, nullables);
        this.implementNotNullAdd(info, add);
        add.exitBlock();
        add.currentBlock().add((Statement)Expressions.ifThen((Expression)condition, (Node)thenBlock.toBlock()));
    }

    protected abstract void implementNotNullAdd(AggContext var1, AggAddContext var2);

    @Override
    public final Expression implementResult(AggContext info, AggResultContext result) {
        Expression seenNotNullRows;
        if (!this.needTrackEmptySet) {
            return RexToLixTranslator.convert(this.implementNotNullResult(info, result), info.returnType());
        }
        String tmpName = result.accumulator().isEmpty() ? "ar" : result.accumulator().get(0) + "$Res";
        ParameterExpression res = Expressions.parameter((int)0, (Type)info.returnType(), (String)result.currentBlock().newName(tmpName));
        List<Expression> acc = result.accumulator();
        BlockBuilder thenBlock = result.nestBlock();
        Expression nonNull = RexToLixTranslator.convert(this.implementNotNullResult(info, result), info.returnType());
        result.exitBlock();
        thenBlock.add(Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)nonNull)));
        BlockStatement thenBranch = thenBlock.toBlock();
        Expression expression = seenNotNullRows = this.trackNullsPerRow ? acc.get(acc.size() - 1) : ((WinAggResultContext)result).hasRows();
        if (thenBranch.statements.size() == 1) {
            return Expressions.condition((Expression)seenNotNullRows, (Expression)nonNull, (Expression)RexImpTable.getDefaultValue(res.getType()));
        }
        result.currentBlock().add((Statement)Expressions.declare((int)0, (ParameterExpression)res, null));
        result.currentBlock().add((Statement)Expressions.ifThenElse((Expression)seenNotNullRows, (Node)thenBranch, (Node)Expressions.statement((Expression)Expressions.assign((Expression)res, (Expression)RexImpTable.getDefaultValue(res.getType())))));
        return res;
    }

    protected Expression implementNotNullResult(AggContext info, AggResultContext result) {
        return result.accumulator().get(0);
    }
}

