/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumUtils;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import hive.org.apache.calcite.linq4j.function.Predicate2;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.BlockStatement;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Statement;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexProgramBuilder;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.Pair;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;

public class EnumerableThetaJoin
extends Join
implements EnumerableRel {
    protected EnumerableThetaJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, JoinRelType joinType, Set<String> variablesStopped) throws InvalidRelException {
        super(cluster, traits, left, right, condition, joinType, variablesStopped);
    }

    @Override
    public EnumerableThetaJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            return new EnumerableThetaJoin(this.getCluster(), traitSet, left, right, condition, joinType, this.variablesStopped);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        switch (this.joinType) {
            case RIGHT: {
                rowCount = this.addEpsilon(rowCount);
                break;
            }
            default: {
                if (this.left.getId() <= this.right.getId()) break;
                rowCount = this.addEpsilon(rowCount);
            }
        }
        double rightRowCount = this.right.getRows();
        double leftRowCount = this.left.getRows();
        if (Double.isInfinite(leftRowCount)) {
            rowCount = leftRowCount;
        }
        if (Double.isInfinite(rightRowCount)) {
            rowCount = rightRowCount;
        }
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0);
    }

    private double addEpsilon(double d) {
        assert (d >= 0.0);
        double d0 = d;
        if (d < 10.0 && (d *= 1.001) != d0) {
            return d;
        }
        if ((d += 1.0) != d0) {
            return d;
        }
        return d *= 1.001;
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), pref.preferArray());
        BlockBuilder builder2 = new BlockBuilder();
        return implementor.result(physType, builder.append((Expression)Expressions.call((Method)BuiltInMethod.THETA_JOIN.method, (Expression[])new Expression[]{leftExpression, rightExpression, this.predicate(implementor, builder2, leftResult.physType, rightResult.physType, this.condition), EnumUtils.joinSelector(this.joinType, physType, ImmutableList.of(leftResult.physType, rightResult.physType)), Expressions.constant((Object)this.joinType.generatesNullsOnLeft()), Expressions.constant((Object)this.joinType.generatesNullsOnRight())})).toBlock());
    }

    Expression predicate(EnumerableRelImplementor implementor, BlockBuilder builder, PhysType leftPhysType, PhysType rightPhysType, RexNode condition) {
        ParameterExpression left_ = Expressions.parameter((Type)leftPhysType.getJavaRowType(), (String)"left");
        ParameterExpression right_ = Expressions.parameter((Type)rightPhysType.getJavaRowType(), (String)"right");
        RexProgramBuilder program = new RexProgramBuilder(implementor.getTypeFactory().builder().addAll(this.left.getRowType().getFieldList()).addAll(this.right.getRowType().getFieldList()).build(), this.getCluster().getRexBuilder());
        program.addCondition(condition);
        builder.add((Statement)Expressions.return_(null, (Expression)RexToLixTranslator.translateCondition(program.getProgram(), implementor.getTypeFactory(), builder, new RexToLixTranslator.InputGetterImpl(ImmutableList.of(Pair.of(left_, leftPhysType), Pair.of(right_, rightPhysType))), implementor.allCorrelateVariables)));
        return Expressions.lambda(Predicate2.class, (BlockStatement)builder.toBlock(), (ParameterExpression[])new ParameterExpression[]{left_, right_});
    }
}

