/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableTableScan;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.plan.Convention;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.convert.ConverterRule;
import hive.org.apache.calcite.rel.logical.LogicalTableScan;
import hive.org.apache.calcite.schema.Table;

public class EnumerableTableScanRule
extends ConverterRule {
    public EnumerableTableScanRule() {
        super(LogicalTableScan.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableTableScanRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        LogicalTableScan scan = (LogicalTableScan)rel;
        RelOptTable relOptTable = scan.getTable();
        Table table = relOptTable.unwrap(Table.class);
        if (!EnumerableTableScan.canHandle(table)) {
            return null;
        }
        Expression expression = relOptTable.getExpression(Object.class);
        if (expression == null) {
            return null;
        }
        return EnumerableTableScan.create(scan.getCluster(), relOptTable);
    }
}

