/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.base.Supplier;
import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.JavaRowFormat;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import hive.org.apache.calcite.interpreter.Row;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.linq4j.tree.Blocks;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.linq4j.tree.Node;
import hive.org.apache.calcite.linq4j.tree.ParameterExpression;
import hive.org.apache.calcite.linq4j.tree.Primitive;
import hive.org.apache.calcite.linq4j.tree.Types;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelCollation;
import hive.org.apache.calcite.rel.RelCollationTraitDef;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.TableScan;
import hive.org.apache.calcite.schema.FilterableTable;
import hive.org.apache.calcite.schema.ProjectableFilterableTable;
import hive.org.apache.calcite.schema.QueryableTable;
import hive.org.apache.calcite.schema.ScannableTable;
import hive.org.apache.calcite.schema.StreamableTable;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.util.BuiltInMethod;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class EnumerableTableScan
extends TableScan
implements EnumerableRel {
    private final Class elementType;

    public EnumerableTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, Class elementType) {
        super(cluster, traitSet, table);
        assert (this.getConvention() instanceof EnumerableConvention);
        this.elementType = elementType;
    }

    public static EnumerableTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
        final Table table = relOptTable.unwrap(Table.class);
        Class elementType = EnumerableTableScan.deduceElementType(table);
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, new Supplier<List<RelCollation>>(){

            @Override
            public List<RelCollation> get() {
                if (table != null) {
                    return table.getStatistic().getCollations();
                }
                return ImmutableList.of();
            }
        });
        return new EnumerableTableScan(cluster, traitSet, relOptTable, elementType);
    }

    public static boolean canHandle(Table table) {
        return table instanceof QueryableTable || table instanceof ScannableTable;
    }

    public static Class deduceElementType(Table table) {
        if (table instanceof QueryableTable) {
            QueryableTable queryableTable = (QueryableTable)table;
            Type type = queryableTable.getElementType();
            if (type instanceof Class) {
                return (Class)type;
            }
            return Object[].class;
        }
        if (table instanceof ScannableTable || table instanceof FilterableTable || table instanceof ProjectableFilterableTable || table instanceof StreamableTable) {
            return Object[].class;
        }
        return Object.class;
    }

    private Expression getExpression(PhysType physType) {
        Expression expression = this.table.getExpression(Queryable.class);
        Expression expression2 = this.toEnumerable(expression);
        assert (Types.isAssignableFrom(Enumerable.class, (Type)expression2.getType()));
        return this.toRows(physType, expression2);
    }

    private Expression toEnumerable(Expression expression) {
        Type type = expression.getType();
        if (Types.isArray((Type)type)) {
            if (Types.toClass((Type)type).getComponentType().isPrimitive()) {
                expression = Expressions.call((Method)BuiltInMethod.AS_LIST.method, (Expression[])new Expression[]{expression});
            }
            return Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE.method, (Expression[])new Expression[]{expression});
        }
        if (Types.isAssignableFrom(Iterable.class, (Type)type) && !Types.isAssignableFrom(Enumerable.class, (Type)type)) {
            return Expressions.call((Method)BuiltInMethod.AS_ENUMERABLE2.method, (Expression[])new Expression[]{expression});
        }
        if (Types.isAssignableFrom(Queryable.class, (Type)type)) {
            return Expressions.call((Expression)expression, (Method)BuiltInMethod.QUERYABLE_AS_ENUMERABLE.method, (Expression[])new Expression[0]);
        }
        return expression;
    }

    private Expression toRows(PhysType physType, Expression expression) {
        if (physType.getFormat() == JavaRowFormat.SCALAR && Object[].class.isAssignableFrom(this.elementType) && this.getRowType().getFieldCount() == 1 && (this.table.unwrap(ScannableTable.class) != null || this.table.unwrap(FilterableTable.class) != null || this.table.unwrap(ProjectableFilterableTable.class) != null)) {
            return Expressions.call((Method)BuiltInMethod.SLICE0.method, (Expression[])new Expression[]{expression});
        }
        JavaRowFormat oldFormat = this.format();
        if (physType.getFormat() == oldFormat) {
            return expression;
        }
        ParameterExpression row_ = Expressions.parameter((Type)this.elementType, (String)"row");
        int fieldCount = this.table.getRowType().getFieldCount();
        ArrayList<Expression> expressionList = new ArrayList<Expression>(fieldCount);
        for (int i = 0; i < fieldCount; ++i) {
            expressionList.add(oldFormat.field((Expression)row_, i, physType.getJavaFieldType(i)));
        }
        return Expressions.call((Expression)expression, (Method)BuiltInMethod.SELECT.method, (Expression[])new Expression[]{Expressions.lambda(Function1.class, (Expression)physType.record(expressionList), (ParameterExpression[])new ParameterExpression[]{row_})});
    }

    private JavaRowFormat format() {
        int fieldCount = this.getRowType().getFieldCount();
        if (fieldCount == 0) {
            return JavaRowFormat.LIST;
        }
        if (Object[].class.isAssignableFrom(this.elementType)) {
            return fieldCount == 1 ? JavaRowFormat.SCALAR : JavaRowFormat.ARRAY;
        }
        if (Row.class.isAssignableFrom(this.elementType)) {
            return JavaRowFormat.ROW;
        }
        if (fieldCount == 1 && (Object.class == this.elementType || Primitive.is((Type)this.elementType) || Number.class.isAssignableFrom(this.elementType))) {
            return JavaRowFormat.SCALAR;
        }
        return JavaRowFormat.CUSTOM;
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableTableScan(this.getCluster(), traitSet, this.table, this.elementType);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), this.format());
        Expression expression = this.getExpression(physType);
        return implementor.result(physType, Blocks.toBlock((Node)expression));
    }
}

