/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import hive.org.apache.calcite.adapter.enumerable.PhysType;
import hive.org.apache.calcite.linq4j.tree.BlockBuilder;
import hive.org.apache.calcite.linq4j.tree.Expression;
import hive.org.apache.calcite.linq4j.tree.Expressions;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.SemiJoin;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.util.BuiltInMethod;
import hive.org.apache.calcite.util.ImmutableIntList;
import hive.org.apache.calcite.util.Util;
import java.lang.reflect.Method;

public class EnumerableSemiJoin
extends SemiJoin
implements EnumerableRel {
    EnumerableSemiJoin(RelOptCluster cluster, RelTraitSet traits, RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) throws InvalidRelException {
        super(cluster, traits, left, right, condition, leftKeys, rightKeys);
    }

    public static EnumerableSemiJoin create(RelNode left, RelNode right, RexNode condition, ImmutableIntList leftKeys, ImmutableIntList rightKeys) {
        RelOptCluster cluster = left.getCluster();
        try {
            return new EnumerableSemiJoin(cluster, cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE), left, right, condition, leftKeys, rightKeys);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public SemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        assert (joinType == JoinRelType.INNER);
        JoinInfo joinInfo = JoinInfo.of(left, right, condition);
        assert (joinInfo.isEqui());
        try {
            return new EnumerableSemiJoin(this.getCluster(), traitSet, left, right, condition, joinInfo.leftKeys, joinInfo.rightKeys);
        }
        catch (InvalidRelException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        double rowCount = RelMetadataQuery.getRowCount(this);
        double rightRowCount = this.right.getRows();
        double leftRowCount = this.left.getRows();
        rowCount = Double.isInfinite(leftRowCount) ? leftRowCount : (rowCount += Util.nLogN(leftRowCount));
        rowCount = Double.isInfinite(rightRowCount) ? rightRowCount : (rowCount += rightRowCount);
        return planner.getCostFactory().makeCost(rowCount, 0.0, 0.0).multiplyBy(0.01);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel.Result leftResult = implementor.visitChild(this, 0, (EnumerableRel)this.left, pref);
        Expression leftExpression = builder.append("left", leftResult.block);
        EnumerableRel.Result rightResult = implementor.visitChild(this, 1, (EnumerableRel)this.right, pref);
        Expression rightExpression = builder.append("right", rightResult.block);
        PhysType physType = leftResult.physType;
        return implementor.result(physType, builder.append((Expression)Expressions.call((Method)BuiltInMethod.SEMI_JOIN.method, (Iterable)Expressions.list((Object[])new Expression[]{leftExpression, rightExpression, leftResult.physType.generateAccessor(this.leftKeys), rightResult.physType.generateAccessor(this.rightKeys)}))).toBlock());
    }
}

