/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableFilter;
import hive.org.apache.calcite.adapter.enumerable.EnumerableJoin;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRules;
import hive.org.apache.calcite.adapter.enumerable.EnumerableThetaJoin;
import hive.org.apache.calcite.plan.Convention;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.AbstractRelNode;
import hive.org.apache.calcite.rel.InvalidRelException;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.convert.ConverterRule;
import hive.org.apache.calcite.rel.core.JoinInfo;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.logical.LogicalJoin;
import java.util.ArrayList;

class EnumerableJoinRule
extends ConverterRule {
    EnumerableJoinRule() {
        super(LogicalJoin.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableJoinRule");
    }

    @Override
    public RelNode convert(RelNode rel) {
        AbstractRelNode newRel;
        RelNode right;
        LogicalJoin join = (LogicalJoin)rel;
        ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
        for (RelNode input : join.getInputs()) {
            if (!(input.getConvention() instanceof EnumerableConvention)) {
                input = EnumerableJoinRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE));
            }
            newInputs.add(input);
        }
        RelOptCluster cluster = join.getCluster();
        RelTraitSet traitSet = join.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode left = (RelNode)newInputs.get(0);
        JoinInfo info = JoinInfo.of(left, right = (RelNode)newInputs.get(1), join.getCondition());
        if (!info.isEqui() && join.getJoinType() != JoinRelType.INNER) {
            try {
                return new EnumerableThetaJoin(cluster, traitSet, left, right, join.getCondition(), join.getJoinType(), join.getVariablesStopped());
            }
            catch (InvalidRelException e) {
                EnumerableRules.LOGGER.fine(e.toString());
                return null;
            }
        }
        try {
            newRel = new EnumerableJoin(cluster, join.getTraitSet().replace(EnumerableConvention.INSTANCE), left, right, info.getEquiCondition(left, right, cluster.getRexBuilder()), info.leftKeys, info.rightKeys, join.getJoinType(), join.getVariablesStopped());
        }
        catch (InvalidRelException e) {
            EnumerableRules.LOGGER.fine(e.toString());
            return null;
        }
        if (!info.isEqui()) {
            newRel = new EnumerableFilter(cluster, newRel.getTraitSet(), newRel, info.getRemaining(cluster.getRexBuilder()));
        }
        return newRel;
    }
}

