/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.enumerable;

import hive.com.google.common.collect.ImmutableMap;
import hive.org.apache.calcite.DataContext;
import hive.org.apache.calcite.adapter.enumerable.EnumerableConvention;
import hive.org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import hive.org.apache.calcite.adapter.enumerable.EnumerableRel;
import hive.org.apache.calcite.interpreter.BindableConvention;
import hive.org.apache.calcite.interpreter.BindableRel;
import hive.org.apache.calcite.interpreter.InterpretableRel;
import hive.org.apache.calcite.interpreter.Node;
import hive.org.apache.calcite.interpreter.Row;
import hive.org.apache.calcite.interpreter.Sink;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.Enumerator;
import hive.org.apache.calcite.plan.ConventionTraitDef;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelTrait;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.convert.ConverterImpl;
import hive.org.apache.calcite.rel.convert.ConverterRule;
import hive.org.apache.calcite.runtime.ArrayBindable;
import hive.org.apache.calcite.runtime.Bindable;
import java.util.List;

public class EnumerableBindable
extends ConverterImpl
implements BindableRel {
    protected EnumerableBindable(RelOptCluster cluster, RelNode input) {
        super(cluster, ConventionTraitDef.INSTANCE, cluster.traitSetOf((RelTrait)BindableConvention.INSTANCE), input);
    }

    @Override
    public EnumerableBindable copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new EnumerableBindable(this.getCluster(), EnumerableBindable.sole(inputs));
    }

    @Override
    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    @Override
    public Enumerable<Object[]> bind(DataContext dataContext) {
        ImmutableMap<String, Object> map = ImmutableMap.of();
        Bindable bindable = EnumerableInterpretable.toBindable(map, null, (EnumerableRel)this.getInput(), EnumerableRel.Prefer.ARRAY);
        ArrayBindable arrayBindable = EnumerableInterpretable.box(bindable);
        return arrayBindable.bind(dataContext);
    }

    @Override
    public Node implement(final InterpretableRel.InterpreterImplementor implementor) {
        return new Node(){

            @Override
            public void run() throws InterruptedException {
                Sink sink = implementor.relSinks.get(EnumerableBindable.this).get(0);
                Enumerable<Object[]> enumerable = EnumerableBindable.this.bind(implementor.dataContext);
                Enumerator enumerator = enumerable.enumerator();
                while (enumerator.moveNext()) {
                    sink.send(Row.asCopy((Object[])enumerator.current()));
                }
            }
        };
    }

    public static class EnumerableToBindableConverterRule
    extends ConverterRule {
        public static final EnumerableToBindableConverterRule INSTANCE = new EnumerableToBindableConverterRule();

        private EnumerableToBindableConverterRule() {
            super(EnumerableRel.class, EnumerableConvention.INSTANCE, BindableConvention.INSTANCE, "EnumerableToBindableConverterRule");
        }

        @Override
        public RelNode convert(RelNode rel) {
            return new EnumerableBindable(rel.getCluster(), rel);
        }
    }
}

