/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.adapter.clone;

import hive.com.google.common.base.Supplier;
import hive.com.google.common.base.Suppliers;
import hive.org.apache.calcite.adapter.clone.ArrayTable;
import hive.org.apache.calcite.adapter.clone.ColumnLoader;
import hive.org.apache.calcite.adapter.java.JavaTypeFactory;
import hive.org.apache.calcite.adapter.jdbc.JdbcSchema;
import hive.org.apache.calcite.avatica.ColumnMetaData;
import hive.org.apache.calcite.jdbc.CalciteConnection;
import hive.org.apache.calcite.linq4j.Enumerable;
import hive.org.apache.calcite.linq4j.QueryProvider;
import hive.org.apache.calcite.linq4j.Queryable;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelProtoDataType;
import hive.org.apache.calcite.schema.QueryableTable;
import hive.org.apache.calcite.schema.Schema;
import hive.org.apache.calcite.schema.SchemaFactory;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.schema.Schemas;
import hive.org.apache.calcite.schema.Table;
import hive.org.apache.calcite.schema.impl.AbstractSchema;
import hive.org.apache.calcite.schema.impl.MaterializedViewTable;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class CloneSchema
extends AbstractSchema {
    private final SchemaPlus sourceSchema;

    public CloneSchema(SchemaPlus sourceSchema) {
        this.sourceSchema = sourceSchema;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        LinkedHashMap<String, Table> map = new LinkedHashMap<String, Table>();
        for (String name : this.sourceSchema.getTableNames()) {
            Table table = this.sourceSchema.getTable(name);
            if (!(table instanceof QueryableTable)) continue;
            QueryableTable sourceTable = (QueryableTable)table;
            map.put(name, this.createCloneTable(MaterializedViewTable.MATERIALIZATION_CONNECTION, sourceTable, name));
        }
        return map;
    }

    private Table createCloneTable(QueryProvider queryProvider, QueryableTable sourceTable, String name) {
        Queryable queryable = sourceTable.asQueryable(queryProvider, this.sourceSchema, name);
        JavaTypeFactory typeFactory = ((CalciteConnection)queryProvider).getTypeFactory();
        return CloneSchema.createCloneTable(typeFactory, Schemas.proto(sourceTable), null, queryable);
    }

    public static <T> Table createCloneTable(final JavaTypeFactory typeFactory, final RelProtoDataType protoRowType, final List<ColumnMetaData.Rep> repList, final Enumerable<T> source) {
        Type elementType = source instanceof QueryableTable ? ((QueryableTable)source).getElementType() : (((RelDataType)protoRowType.apply(typeFactory)).getFieldCount() == 1 ? (repList != null ? repList.get((int)0).clazz : Object.class) : Object[].class);
        return new ArrayTable(elementType, protoRowType, Suppliers.memoize(new Supplier<ArrayTable.Content>(){

            @Override
            public ArrayTable.Content get() {
                ColumnLoader loader = new ColumnLoader(typeFactory, source, protoRowType, repList);
                return new ArrayTable.Content(loader.representationValues, loader.size(), loader.sortField);
            }
        }));
    }

    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            SchemaPlus schema = parentSchema.add(name, JdbcSchema.create(parentSchema, name + "$source", operand));
            return new CloneSchema(schema);
        }
    }
}

