/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.hbase.HBaseKeyFactory;
import org.apache.hadoop.hive.hbase.struct.HBaseValueFactory;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazySerDeParameters;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyObjectInspectorParameters;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class HBaseLazyObjectFactory {
    public static ObjectInspector createLazyHBaseStructInspector(LazySerDeParameters serdeParams, int index, HBaseKeyFactory keyFactory, List<HBaseValueFactory> valueFactories) throws SerDeException {
        List columnTypes = serdeParams.getColumnTypes();
        ArrayList<ObjectInspector> columnObjectInspectors = new ArrayList<ObjectInspector>(columnTypes.size());
        for (int i = 0; i < columnTypes.size(); ++i) {
            if (i == index) {
                columnObjectInspectors.add(keyFactory.createKeyObjectInspector((TypeInfo)columnTypes.get(i)));
                continue;
            }
            columnObjectInspectors.add(valueFactories.get(i).createValueObjectInspector((TypeInfo)columnTypes.get(i)));
        }
        return LazyObjectInspectorFactory.getLazySimpleStructObjectInspector((List)serdeParams.getColumnNames(), columnObjectInspectors, null, (byte)serdeParams.getSeparators()[0], (LazyObjectInspectorParameters)serdeParams, (ObjectInspectorFactory.ObjectInspectorOptions)ObjectInspectorFactory.ObjectInspectorOptions.JAVA);
    }
}

