/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.ResultSet;
import java.util.List;
import net.hydromatic.avatica.AvaticaPrepareResult;
import net.hydromatic.avatica.AvaticaResultSet;
import net.hydromatic.avatica.AvaticaStatement;
import net.hydromatic.avatica.Cursor;
import net.hydromatic.avatica.Meta;
import org.apache.drill.common.exceptions.DrillRuntimeException;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.jdbc.impl.DrillConnectionImpl;
import org.apache.drill.jdbc.impl.DrillPrepareResult;
import org.apache.drill.jdbc.impl.DrillResultSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MetaImpl
implements Meta {
    private static final Logger logger = LoggerFactory.getLogger(MetaImpl.class);
    private static final int DECIMAL_DIGITS_REAL = 7;
    private static final int DECIMAL_DIGITS_FLOAT = 7;
    private static final int DECIMAL_DIGITS_DOUBLE = 15;
    private static final int RADIX_DATETIME = 10;
    private static final int RADIX_INTERVAL = 10;
    final DrillConnectionImpl connection;

    MetaImpl(DrillConnectionImpl connection) {
        this.connection = connection;
    }

    public String getSqlKeywords() {
        return "";
    }

    public String getNumericFunctions() {
        return "";
    }

    public String getStringFunctions() {
        return "";
    }

    public String getSystemFunctions() {
        return "";
    }

    public String getTimeDateFunctions() {
        return "";
    }

    private ResultSet s(String s) {
        try {
            logger.debug("Running {}", (Object)s);
            AvaticaStatement statement = this.connection.createStatement();
            statement.execute(s);
            return statement.getResultSet();
        }
        catch (Exception e) {
            throw new DrillRuntimeException("Failure while attempting to get DatabaseMetadata.", (Throwable)e);
        }
    }

    private ResultSet getEmptyResultSet() {
        return this.s("SELECT '' AS `Interim zero-row result set` FROM INFORMATION_SCHEMA.CATALOGS LIMIT 0");
    }

    public ResultSet getTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, List<String> typeList) {
        StringBuilder sb = new StringBuilder();
        sb.append("select TABLE_CATALOG as TABLE_CAT, TABLE_SCHEMA as TABLE_SCHEM, TABLE_NAME, TABLE_TYPE, '' as REMARKS, '' as TYPE_CAT, '' as TYPE_SCHEM, '' as TYPE_NAME, '' as SELF_REFERENCING_COL_NAME, '' as REF_GENERATION FROM INFORMATION_SCHEMA.`TABLES` WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND TABLE_CATALOG = '" + DrillStringUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND TABLE_SCHEMA like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append(" AND TABLE_NAME like '" + DrillStringUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (typeList != null && typeList.size() > 0) {
            sb.append("AND (");
            for (int t = 0; t < typeList.size(); ++t) {
                if (t != 0) {
                    sb.append(" OR ");
                }
                sb.append(" TABLE_TYPE LIKE '" + DrillStringUtils.escapeSql((String)typeList.get(t)) + "' ");
            }
            sb.append(")");
        }
        sb.append(" ORDER BY TABLE_TYPE, TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT \n  TABLE_CATALOG                 as  TABLE_CAT, \n  TABLE_SCHEMA                  as  TABLE_SCHEM, \n  TABLE_NAME                    as  TABLE_NAME, \n  COLUMN_NAME                   as  COLUMN_NAME, \n  CASE DATA_TYPE \n    WHEN 'ARRAY'                       THEN 2003\n    WHEN 'BIGINT'                      THEN -5\n    WHEN 'BINARY'                      THEN -2\n    WHEN 'BINARY LARGE OBJECT'         THEN 2004\n    WHEN 'BINARY VARYING'              THEN -3\n    WHEN 'BIT'                         THEN -7\n    WHEN 'BOOLEAN'                     THEN 16\n    WHEN 'CHARACTER'                   THEN 1\n    WHEN 'CHARACTER LARGE OBJECT'      THEN 2005\n    WHEN 'CHARACTER VARYING'           THEN 12\n    WHEN 'DATALINK'                    THEN 70\n    WHEN 'DATE'                        THEN 91\n    WHEN 'DECIMAL'                     THEN 3\n    WHEN 'DISTINCT'                    THEN 2001\n    WHEN 'DOUBLE', 'DOUBLE PRECISION'  THEN 8\n    WHEN 'FLOAT'                       THEN 6\n    WHEN 'INTEGER'                     THEN 4\n    WHEN 'INTERVAL'                    THEN 1111\n    WHEN 'JAVA_OBJECT'                 THEN 2000\n    WHEN 'LONGNVARCHAR'                THEN -16\n    WHEN 'LONGVARBINARY'               THEN -4\n    WHEN 'LONGVARCHAR'                 THEN -1\n    WHEN 'MAP'                         THEN 1111\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER LARGE OBJECT' \n                                       THEN 2011\n    WHEN 'NULL'                        THEN 0\n    WHEN 'NUMERIC'                     THEN 2\n    WHEN 'NATIONAL CHARACTER'          THEN -15\n    WHEN 'NATIONAL CHARACTER VARYING'  THEN -9\n    WHEN 'OTHER'                       THEN 1111\n    WHEN 'REAL'                        THEN 7\n    WHEN 'REF'                         THEN 2006\n    WHEN 'ROWID'                       THEN -8\n    WHEN 'SMALLINT'                    THEN 5\n    WHEN 'SQLXML'                      THEN 2009\n    WHEN 'STRUCT'                      THEN 2002\n    WHEN 'TIME'                        THEN 92\n    WHEN 'TIMESTAMP'                   THEN 93\n    WHEN 'TINYINT'                     THEN -6\n    ELSE                                    1111\n  END                                    as  DATA_TYPE, \n  DATA_TYPE                     as  TYPE_NAME, \n  CASE DATA_TYPE \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE' \n                         THEN NUMERIC_PRECISION \n    WHEN 'CHARACTER', 'CHARACTER VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    WHEN 'DATE'          THEN 10 \n    WHEN 'TIME'          THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0 \n                         THEN          8 + 1 + DATETIME_PRECISION\n        ELSE                           8\n      END \n    WHEN 'TIMESTAMP'     THEN \n      CASE \n        WHEN DATETIME_PRECISION > 0                            THEN 10 + 1 + 8 + 1 + DATETIME_PRECISION\n        ELSE                  10 + 1 + 8\n      END \n    WHEN 'INTERVAL'      THEN \n      INTERVAL_PRECISION \n      + \n      CASE INTERVAL_TYPE \n        WHEN 'YEAR', 'MONTH', 'DAY' THEN 2 \n        WHEN 'HOUR', 'MINUTE'       THEN 3 \n        WHEN 'YEAR TO MONTH'        THEN 5 \n        WHEN 'DAY TO HOUR'          THEN 6 \n        WHEN 'HOUR TO MINUTE'       THEN 6 \n        WHEN 'DAY TO MINUTE'        THEN 9 \n        ELSE \n          CASE INTERVAL_TYPE \n            WHEN 'DAY TO SECOND'    THEN 12 \n            WHEN 'HOUR TO SECOND'   THEN  9 \n            WHEN 'MINUTE TO SECOND' THEN  6 \n            WHEN 'SECOND'           THEN  3 \n            ELSE \n                                    0-INTERVAL_PRECISION - 1 \n          END \n          + \n          DATETIME_PRECISION\n          + \n          CASE \n            WHEN DATETIME_PRECISION > 0 THEN 1\n            ELSE                             0 \n          END\n      END \n    WHEN 'BINARY', 'BINARY VARYING' \n                         THEN CHARACTER_MAXIMUM_LENGTH \n    ELSE                      NULL \n  END                                    as  COLUMN_SIZE, \n  CHARACTER_MAXIMUM_LENGTH      as  BUFFER_LENGTH, \n  CASE  DATA_TYPE\n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC'        THEN NUMERIC_SCALE \n    WHEN 'REAL'                      THEN 7\n    WHEN 'FLOAT'                     THEN 7\n    WHEN 'DOUBLE'                    THEN 15\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN DATETIME_PRECISION \n    WHEN 'INTERVAL'                  THEN DATETIME_PRECISION \n  END                                    as  DECIMAL_DIGITS, \n  CASE DATA_TYPE \n    WHEN 'TINYINT', 'SMALLINT', 'INTEGER', 'BIGINT', \n         'DECIMAL', 'NUMERIC', \n         'REAL', 'FLOAT', 'DOUBLE'   THEN NUMERIC_PRECISION_RADIX \n    WHEN 'INTERVAL'                  THEN 10\n    WHEN 'DATE', 'TIME', 'TIMESTAMP' THEN 10\n    ELSE                                  NULL\n  END                                    as  NUM_PREC_RADIX, \n  CASE IS_NULLABLE \n    WHEN 'YES'      THEN 1\n    WHEN 'NO'       THEN 0\n    WHEN ''         THEN 2\n    ELSE                 -1\n  END                                    as  NULLABLE, \n  CAST( NULL as VARCHAR )       as  REMARKS, \n  COLUMN_DEFAULT                as  COLUMN_DEF, \n  0                             as  SQL_DATA_TYPE, \n  0                             as  SQL_DATETIME_SUB, \n  CASE DATA_TYPE\n    WHEN 'CHARACTER', \n         'CHARACTER VARYING', \n         'NATIONAL CHARACTER', \n         'NATIONAL CHARACTER VARYING' \n                                 THEN CHARACTER_OCTET_LENGTH \n    ELSE                              NULL \n  END                                    as  CHAR_OCTET_LENGTH, \n  ORDINAL_POSITION              as  ORDINAL_POSITION, \n  IS_NULLABLE                   as  IS_NULLABLE, \n  CAST( NULL as VARCHAR )       as  SCOPE_CATALOG, \n  CAST( NULL as VARCHAR )       as  SCOPE_SCHEMA, \n  CAST( NULL as VARCHAR )       as  SCOPE_TABLE, \n  CAST( NULL as INTEGER )       as  SOURCE_DATA_TYPE, \n  ''                            as  IS_AUTOINCREMENT, \n  ''                            as  IS_GENERATEDCOLUMN \n  FROM INFORMATION_SCHEMA.COLUMNS \n  WHERE 1=1 ");
        if (catalog != null) {
            sb.append("\n  AND TABLE_CATALOG = '" + DrillStringUtils.escapeSql((String)catalog) + "'");
        }
        if (schemaPattern.s != null) {
            sb.append("\n  AND TABLE_SCHEMA like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        if (tableNamePattern.s != null) {
            sb.append("\n  AND TABLE_NAME like '" + DrillStringUtils.escapeSql((String)tableNamePattern.s) + "'");
        }
        if (columnNamePattern.s != null) {
            sb.append("\n  AND COLUMN_NAME like '" + DrillStringUtils.escapeSql((String)columnNamePattern.s) + "'");
        }
        sb.append("\n ORDER BY TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, COLUMN_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getSchemas(String catalog, Meta.Pat schemaPattern) {
        StringBuilder sb = new StringBuilder();
        sb.append("select SCHEMA_NAME as TABLE_SCHEM, CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.SCHEMATA WHERE 1=1 ");
        if (catalog != null) {
            sb.append(" AND CATALOG_NAME = '" + DrillStringUtils.escapeSql((String)catalog) + "' ");
        }
        if (schemaPattern.s != null) {
            sb.append(" AND SCHEMA_NAME like '" + DrillStringUtils.escapeSql((String)schemaPattern.s) + "'");
        }
        sb.append(" ORDER BY CATALOG_NAME, SCHEMA_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getCatalogs() {
        StringBuilder sb = new StringBuilder();
        sb.append("select CATALOG_NAME as TABLE_CAT  FROM INFORMATION_SCHEMA.CATALOGS ");
        sb.append(" ORDER BY CATALOG_NAME");
        return this.s(sb.toString());
    }

    public ResultSet getTableTypes() {
        return this.getEmptyResultSet();
    }

    public ResultSet getProcedures(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getProcedureColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat procedureNamePattern, Meta.Pat columnNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getColumnPrivileges(String catalog, String schema, String table, Meta.Pat columnNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getTablePrivileges(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) {
        return this.getEmptyResultSet();
    }

    public ResultSet getVersionColumns(String catalog, String schema, String table) {
        return this.getEmptyResultSet();
    }

    public ResultSet getPrimaryKeys(String catalog, String schema, String table) {
        return this.getEmptyResultSet();
    }

    public ResultSet getImportedKeys(String catalog, String schema, String table) {
        return this.getEmptyResultSet();
    }

    public ResultSet getExportedKeys(String catalog, String schema, String table) {
        return this.getEmptyResultSet();
    }

    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) {
        return this.getEmptyResultSet();
    }

    public ResultSet getTypeInfo() {
        return this.getEmptyResultSet();
    }

    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) {
        return this.getEmptyResultSet();
    }

    public ResultSet getUDTs(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, int[] types) {
        return this.getEmptyResultSet();
    }

    public ResultSet getSuperTypes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getSuperTables(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getAttributes(String catalog, Meta.Pat schemaPattern, Meta.Pat typeNamePattern, Meta.Pat attributeNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getClientInfoProperties() {
        return this.getEmptyResultSet();
    }

    public ResultSet getFunctions(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getFunctionColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat functionNamePattern, Meta.Pat columnNamePattern) {
        return this.getEmptyResultSet();
    }

    public ResultSet getPseudoColumns(String catalog, Meta.Pat schemaPattern, Meta.Pat tableNamePattern, Meta.Pat columnNamePattern) {
        return this.getEmptyResultSet();
    }

    public Cursor createCursor(AvaticaResultSet resultSet_) {
        return ((DrillResultSetImpl)resultSet_).cursor;
    }

    public AvaticaPrepareResult prepare(AvaticaStatement statement_, String sql) {
        return new DrillPrepareResult(sql);
    }

    static interface Named {
        public String getName();
    }
}

