

/*******************************************************************************

 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ******************************************************************************/
package org.apache.drill.exec.expr.fn.impl;


import static com.google.common.base.Preconditions.checkArgument;
import static com.google.common.base.Preconditions.checkState;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.base.Charsets;
import com.google.common.collect.ObjectArrays;

import com.google.common.base.Preconditions;
import io.netty.buffer.*;

import org.apache.commons.lang3.ArrayUtils;

import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.expr.fn.impl.StringFunctionUtil;
import org.apache.drill.exec.memory.*;
import org.apache.drill.exec.proto.SchemaDefProtos;
import org.apache.drill.exec.proto.UserBitShared;
import org.apache.drill.exec.proto.UserBitShared.DrillPBError;
import org.apache.drill.exec.proto.UserBitShared.SerializedField;
import org.apache.drill.exec.record.*;
import org.apache.drill.exec.vector.*;
import org.apache.drill.common.exceptions.*;
import org.apache.drill.exec.exception.*;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.common.expression.FieldReference;
import org.apache.drill.common.types.TypeProtos.*;
import org.apache.drill.common.types.Types;
import org.apache.drill.common.util.DrillStringUtils;
import org.apache.drill.exec.vector.complex.*;
import org.apache.drill.exec.vector.complex.reader.*;
import org.apache.drill.exec.vector.complex.impl.*;
import org.apache.drill.exec.vector.complex.writer.*;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.MapWriter;
import org.apache.drill.exec.vector.complex.writer.BaseWriter.ListWriter;
import org.apache.drill.exec.util.JsonStringArrayList;

import org.apache.drill.exec.memory.OutOfMemoryRuntimeException;

import com.sun.codemodel.JType;
import com.sun.codemodel.JCodeModel;

import javax.inject.Inject;

import java.util.Arrays;
import java.util.Random;
import java.util.List;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.math.BigDecimal;
import java.math.BigInteger;

import org.joda.time.DateTime;
import org.joda.time.Period;

import org.apache.hadoop.io.Text;

import org.apache.drill.exec.vector.accessor.sql.TimePrintMillis;
import javax.inject.Inject;





import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.holders.*;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;
import org.apache.drill.exec.record.RecordBatch;

/*
 * This class is generated using freemarker and the UnionFunctions.java template.
 */

@SuppressWarnings("unused")
/**
 * Additional functions can be found in the class UnionFunctions
 */
public class GUnionFunctions {



  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_TINYINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsTinyInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.TINYINT ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_TINYINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionTinyInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableTinyIntHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_UINT1", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsUInt1 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.UINT1 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_UINT1", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionUInt1 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableUInt1Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_UINT2", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsUInt2 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.UINT2 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_UINT2", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionUInt2 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableUInt2Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_SMALLINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsSmallInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.SMALLINT ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_SMALLINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionSmallInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableSmallIntHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_INT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.INT ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_INT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableIntHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_UINT4", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsUInt4 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.UINT4 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_UINT4", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionUInt4 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableUInt4Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_FLOAT4", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsFloat4 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.FLOAT4 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_FLOAT4", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionFloat4 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableFloat4Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_TIME", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsTime implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.TIME ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_TIME", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionTime implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableTimeHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_INTERVALYEAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsIntervalYear implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.INTERVALYEAR ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_INTERVALYEAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionIntervalYear implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableIntervalYearHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }






  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_BIGINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsBigInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.BIGINT ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_BIGINT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionBigInt implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableBigIntHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_UINT8", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsUInt8 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.UINT8 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_UINT8", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionUInt8 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableUInt8Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_FLOAT8", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsFloat8 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.FLOAT8 ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_FLOAT8", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionFloat8 implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableFloat8Holder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_DATE", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsDate implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.DATE ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_DATE", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionDate implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableDateHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_TIMESTAMP", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsTimeStamp implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.TIMESTAMP ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_TIMESTAMP", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionTimeStamp implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableTimeStampHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }






  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_INTERVALDAY", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsIntervalDay implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.INTERVALDAY ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_INTERVALDAY", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionIntervalDay implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableIntervalDayHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_INTERVAL", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsInterval implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.INTERVAL ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_INTERVAL", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionInterval implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableIntervalHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }












  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_VARBINARY", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsVarBinary implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.VARBINARY ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_VARBINARY", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionVarBinary implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableVarBinaryHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_VARCHAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsVarChar implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.VARCHAR ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_VARCHAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionVarChar implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableVarCharHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_VAR16CHAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsVar16Char implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.VAR16CHAR ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_VAR16CHAR", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionVar16Char implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableVar16CharHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }




  @SuppressWarnings("unused")
  @FunctionTemplate(name = "IS_BIT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class UnionIsBit implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        out.value = in.getType().getMinorType() == org.apache.drill.common.types.TypeProtos.MinorType.BIT ? 1 : 0;
      } else {
        out.value = 0;
      }
    }
  }

  @SuppressWarnings("unused")
  @FunctionTemplate(name = "ASSERT_BIT", scope = FunctionTemplate.FunctionScope.SIMPLE, nulls=NullHandling.INTERNAL)
  public static class CastUnionBit implements DrillSimpleFunc {

    @Param UnionHolder in;
    @Output NullableBitHolder out;

    public void setup() {}

    public void eval() {
      if (in.isSet == 1) {
        in.reader.read(out);
      } else {
        out.isSet = 0;
      }
    }
  }



}
