/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import net.hydromatic.avatica.Cursor;
import org.apache.drill.exec.expr.TypeHelper;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.vector.ValueVector;
import org.apache.drill.exec.vector.accessor.BoundCheckingAccessor;
import org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.jdbc.impl.AvaticaDrillSqlAccessor;
import org.apache.drill.jdbc.impl.BasicList;
import org.apache.drill.jdbc.impl.DrillCursor;
import org.apache.drill.jdbc.impl.TypeConvertingSqlAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillAccessorList
extends BasicList<Cursor.Accessor> {
    static final Logger logger = LoggerFactory.getLogger(DrillAccessorList.class);
    private AvaticaDrillSqlAccessor[] accessors = new AvaticaDrillSqlAccessor[0];
    private int lastColumn = 1;

    DrillAccessorList() {
    }

    void generateAccessors(DrillCursor cursor, RecordBatchLoader currentBatch) {
        int cnt = currentBatch.getSchema().getFieldCount();
        this.accessors = new AvaticaDrillSqlAccessor[cnt];
        for (int i = 0; i < cnt; ++i) {
            ValueVector vector = currentBatch.getValueAccessorById(null, new int[]{i}).getValueVector();
            TypeConvertingSqlAccessor acc = new TypeConvertingSqlAccessor((SqlAccessor)new BoundCheckingAccessor(vector, TypeHelper.getSqlAccessor((ValueVector)vector)));
            this.accessors[i] = new AvaticaDrillSqlAccessor(acc, cursor);
        }
    }

    @Override
    public AvaticaDrillSqlAccessor get(int index) {
        this.lastColumn = index;
        return this.accessors[index];
    }

    boolean wasNull() throws SQLException {
        return this.accessors[this.lastColumn].wasNull();
    }

    @Override
    public int size() {
        return this.accessors.length;
    }
}

