/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.remote.Service;

public abstract class JsonService
implements Service {
    protected static final ObjectMapper MAPPER = new ObjectMapper();

    public abstract String apply(String var1);

    private static Meta.Signature finagle(Meta.Signature signature) {
        ArrayList<ColumnMetaData> columns = new ArrayList<ColumnMetaData>();
        for (ColumnMetaData column : signature.columns) {
            columns.add(JsonService.finagle(column));
        }
        if (columns.equals(signature.columns)) {
            return signature;
        }
        return new Meta.Signature(columns, signature.sql, signature.parameters, signature.internalParameters, signature.cursorFactory);
    }

    private static ColumnMetaData finagle(ColumnMetaData column) {
        switch (column.type.rep) {
            case BYTE: 
            case PRIMITIVE_BYTE: 
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: 
            case FLOAT: 
            case PRIMITIVE_FLOAT: 
            case INTEGER: 
            case PRIMITIVE_INT: 
            case SHORT: 
            case PRIMITIVE_SHORT: 
            case LONG: 
            case PRIMITIVE_LONG: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        switch (column.type.id) {
            case -3: 
            case -2: {
                return column.setRep(ColumnMetaData.Rep.STRING);
            }
            case 2: 
            case 3: {
                return column.setRep(ColumnMetaData.Rep.NUMBER);
            }
        }
        return column;
    }

    private static Service.PrepareResponse finagle(Service.PrepareResponse response) {
        Meta.StatementHandle statement = JsonService.finagle(response.statement);
        if (statement == response.statement) {
            return response;
        }
        return new Service.PrepareResponse(statement);
    }

    private static Meta.StatementHandle finagle(Meta.StatementHandle h) {
        Meta.Signature signature = JsonService.finagle(h.signature);
        if (signature == h.signature) {
            return h;
        }
        return new Meta.StatementHandle(h.connectionId, h.id, signature);
    }

    private static Service.ResultSetResponse finagle(Service.ResultSetResponse r) {
        if (r.updateCount != -1L) {
            assert (r.signature == null);
            return r;
        }
        Meta.Signature signature = JsonService.finagle(r.signature);
        if (signature == r.signature) {
            return r;
        }
        return new Service.ResultSetResponse(r.connectionId, r.statementId, r.ownStatement, signature, r.firstFrame, r.updateCount);
    }

    private static Service.ExecuteResponse finagle(Service.ExecuteResponse r) {
        ArrayList<Service.ResultSetResponse> results = new ArrayList<Service.ResultSetResponse>();
        int changeCount = 0;
        for (Service.ResultSetResponse result : r.results) {
            Service.ResultSetResponse result2 = JsonService.finagle(result);
            if (result2 != result) {
                ++changeCount;
            }
            results.add(result2);
        }
        if (changeCount == 0) {
            return r;
        }
        return new Service.ExecuteResponse(results);
    }

    protected static <T> T decode(String response, Class<T> valueType) throws IOException {
        return (T)MAPPER.readValue(response, valueType);
    }

    protected static <T> String encode(T request) throws IOException {
        StringWriter w = new StringWriter();
        MAPPER.writeValue((Writer)w, request);
        return w.toString();
    }

    protected RuntimeException handle(IOException e) {
        return new RuntimeException(e);
    }

    @Override
    public Service.ResultSetResponse apply(Service.CatalogsRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.SchemasRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TablesRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TableTypesRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.TypeInfoRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ResultSetResponse apply(Service.ColumnsRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ResultSetResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.PrepareResponse apply(Service.PrepareRequest request) {
        try {
            return JsonService.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.PrepareResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ExecuteResponse apply(Service.PrepareAndExecuteRequest request) {
        try {
            return JsonService.finagle(JsonService.decode(this.apply(JsonService.encode(request)), Service.ExecuteResponse.class));
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.FetchResponse apply(Service.FetchRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.FetchResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CreateStatementResponse apply(Service.CreateStatementRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CreateStatementResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CloseStatementResponse apply(Service.CloseStatementRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CloseStatementResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.CloseConnectionResponse apply(Service.CloseConnectionRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.CloseConnectionResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.ConnectionSyncResponse apply(Service.ConnectionSyncRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.ConnectionSyncResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    @Override
    public Service.DatabasePropertyResponse apply(Service.DatabasePropertyRequest request) {
        try {
            return JsonService.decode(this.apply(JsonService.encode(request)), Service.DatabasePropertyResponse.class);
        }
        catch (IOException e) {
            throw this.handle(e);
        }
    }

    static {
        MAPPER.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        MAPPER.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        MAPPER.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
    }
}

