/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import hive.org.apache.calcite.plan.RelOptRule;
import hive.org.apache.calcite.plan.RelOptRuleCall;
import hive.org.apache.calcite.plan.RelOptRuleOperand;
import hive.org.apache.calcite.plan.RelOptUtil;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.Join;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.rules.FilterJoinRule;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.util.ImmutableBitSet;
import java.util.BitSet;
import java.util.List;
import java.util.ListIterator;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveFilter;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;

public abstract class HiveFilterJoinRule
extends FilterJoinRule {
    public static final HiveFilterJoinRule FILTER_ON_JOIN = new HiveFilterJoinMergeRule();
    public static final HiveFilterJoinRule JOIN = new HiveFilterJoinTransposeRule();

    protected HiveFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelFactories.FilterFactory filterFactory, RelFactories.ProjectFactory projectFactory) {
        super(operand, id, smart, filterFactory, projectFactory);
    }

    @Override
    protected void validateJoinFilters(List<RexNode> aboveFilters, List<RexNode> joinFilters, Join join, JoinRelType joinType) {
        if (joinType.equals((Object)JoinRelType.INNER)) {
            ListIterator<RexNode> filterIter = joinFilters.listIterator();
            while (filterIter.hasNext()) {
                RexNode exp = filterIter.next();
                if (exp instanceof RexCall) {
                    RexCall c = (RexCall)exp;
                    boolean validHiveJoinFilter = false;
                    if (c.getOperator().getKind() == SqlKind.EQUALS) {
                        validHiveJoinFilter = true;
                        for (RexNode rn : c.getOperands()) {
                            if (!this.filterRefersToBothSidesOfJoin(rn, join)) continue;
                            validHiveJoinFilter = false;
                            break;
                        }
                    } else if (c.getOperator().getKind() == SqlKind.LESS_THAN || c.getOperator().getKind() == SqlKind.GREATER_THAN || c.getOperator().getKind() == SqlKind.LESS_THAN_OR_EQUAL || c.getOperator().getKind() == SqlKind.GREATER_THAN_OR_EQUAL) {
                        validHiveJoinFilter = true;
                        if (this.filterRefersToBothSidesOfJoin(c, join)) {
                            validHiveJoinFilter = false;
                        }
                    }
                    if (validHiveJoinFilter) continue;
                }
                aboveFilters.add(exp);
                filterIter.remove();
            }
        }
    }

    private boolean filterRefersToBothSidesOfJoin(RexNode filter, Join j) {
        boolean refersToBothSides = false;
        int joinNoOfProjects = j.getRowType().getFieldCount();
        ImmutableBitSet filterProjs = ImmutableBitSet.FROM_BIT_SET.apply(new BitSet(joinNoOfProjects));
        ImmutableBitSet allLeftProjs = filterProjs.union(ImmutableBitSet.range(0, j.getInput(0).getRowType().getFieldCount()));
        ImmutableBitSet allRightProjs = filterProjs.union(ImmutableBitSet.range(j.getInput(0).getRowType().getFieldCount(), joinNoOfProjects));
        if (allLeftProjs.intersects(filterProjs = filterProjs.union(RelOptUtil.InputFinder.bits(filter))) && allRightProjs.intersects(filterProjs)) {
            refersToBothSides = true;
        }
        return refersToBothSides;
    }

    public static class HiveFilterJoinTransposeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinTransposeRule() {
            super(RelOptRule.operand(Join.class, RelOptRule.any()), "HiveFilterJoinRule:no-filter", true, HiveFilter.DEFAULT_FILTER_FACTORY, HiveProject.DEFAULT_PROJECT_FACTORY);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            List<RexNode> joinConds = RelOptUtil.conjunctions(join.getCondition());
            for (RexNode joinCnd : joinConds) {
                if (HiveCalciteUtil.isDeterministic(joinCnd)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            super.perform(call, null, join);
        }
    }

    public static class HiveFilterJoinMergeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinMergeRule() {
            super(RelOptRule.operand(Filter.class, RelOptRule.operand(Join.class, RelOptRule.any()), new RelOptRuleOperand[0]), "HiveFilterJoinRule:filter", true, HiveFilter.DEFAULT_FILTER_FACTORY, HiveProject.DEFAULT_PROJECT_FACTORY);
        }

        @Override
        public boolean matches(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            return HiveCalciteUtil.isDeterministic(filter.getCondition());
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            super.perform(call, filter, join);
        }
    }
}

