/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.plan.RelOptPlanner;
import hive.org.apache.calcite.plan.RelTraitSet;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.Filter;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.metadata.RelMetadataQuery;
import hive.org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveFilter
extends Filter
implements HiveRelNode {
    public static final RelFactories.FilterFactory DEFAULT_FILTER_FACTORY = new HiveFilterFactoryImpl();

    public HiveFilter(RelOptCluster cluster, RelTraitSet traits, RelNode child, RexNode condition) {
        super(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, condition);
    }

    @Override
    public Filter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        assert (traitSet.containsIfApplicable(HiveRelNode.CONVENTION));
        return new HiveFilter(this.getCluster(), traitSet, input, this.getCondition());
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner) {
        return RelMetadataQuery.getNonCumulativeCost(this);
    }

    private static class HiveFilterFactoryImpl
    implements RelFactories.FilterFactory {
        private HiveFilterFactoryImpl() {
        }

        @Override
        public RelNode createFilter(RelNode child, RexNode condition) {
            RelOptCluster cluster = child.getCluster();
            HiveFilter filter = new HiveFilter(cluster, TraitsUtil.getDefaultTraitSet(cluster), child, condition);
            return filter;
        }
    }
}

