/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.cost;

import hive.com.google.common.collect.ImmutableList;
import hive.org.apache.calcite.plan.RelOptCost;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import hive.org.apache.calcite.rel.metadata.RelMdPercentageOriginalRows;
import hive.org.apache.calcite.rel.metadata.RelMetadataProvider;
import hive.org.apache.calcite.util.BuiltInMethod;
import org.apache.hadoop.hive.ql.optimizer.calcite.cost.HiveCostModel;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveTableScan;

public class HiveRelMdCost {
    private final HiveCostModel hiveCostModel;

    public HiveRelMdCost(HiveCostModel hiveCostModel) {
        this.hiveCostModel = hiveCostModel;
    }

    public RelMetadataProvider getMetadataProvider() {
        return ChainedRelMetadataProvider.of(ImmutableList.of(ReflectiveRelMetadataProvider.reflectiveSource((Object)this, BuiltInMethod.NON_CUMULATIVE_COST.method), RelMdPercentageOriginalRows.SOURCE));
    }

    public RelOptCost getNonCumulativeCost(HiveAggregate aggregate) {
        return this.hiveCostModel.getAggregateCost(aggregate);
    }

    public RelOptCost getNonCumulativeCost(HiveJoin join) {
        return this.hiveCostModel.getJoinCost(join);
    }

    public RelOptCost getNonCumulativeCost(HiveTableScan ts) {
        return this.hiveCostModel.getScanCost(ts);
    }

    public RelOptCost getNonCumulativeCost(RelNode rel) {
        return this.hiveCostModel.getDefaultCost();
    }
}

