/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.convert;

import hive.parquet.io.api.Converter;
import hive.parquet.io.api.GroupConverter;
import hive.parquet.io.api.PrimitiveConverter;
import hive.parquet.schema.GroupType;
import hive.parquet.schema.OriginalType;
import hive.parquet.schema.PrimitiveType;
import hive.parquet.schema.Type;
import java.util.Map;
import org.apache.hadoop.hive.ql.io.parquet.convert.ConverterParent;
import org.apache.hadoop.hive.ql.io.parquet.convert.ETypeConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveCollectionConverter;
import org.apache.hadoop.hive.ql.io.parquet.convert.HiveStructConverter;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;

public abstract class HiveGroupConverter
extends GroupConverter
implements ConverterParent {
    private Map<String, String> metadata;

    public void setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    protected static PrimitiveConverter getConverterFromDescription(PrimitiveType type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        return ETypeConverter.getNewConverter(type, index, parent);
    }

    protected static HiveGroupConverter getConverterFromDescription(GroupType type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        OriginalType annotation = type.getOriginalType();
        if (annotation == OriginalType.LIST) {
            return HiveCollectionConverter.forList(type, parent, index);
        }
        if (annotation == OriginalType.MAP || annotation == OriginalType.MAP_KEY_VALUE) {
            return HiveCollectionConverter.forMap(type, parent, index);
        }
        return new HiveStructConverter(type, parent, index);
    }

    protected static Converter getConverterFromDescription(Type type, int index, ConverterParent parent) {
        if (type == null) {
            return null;
        }
        if (type.isPrimitive()) {
            return HiveGroupConverter.getConverterFromDescription(type.asPrimitiveType(), index, parent);
        }
        return HiveGroupConverter.getConverterFromDescription(type.asGroupType(), index, parent);
    }

    static ArrayWritable wrapList(ArrayWritable list) {
        return new ArrayWritable(Writable.class, new Writable[]{list});
    }

    @Override
    public abstract void set(int var1, Writable var2);
}

