/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.format.converter;

import hive.parquet.Log;
import hive.parquet.column.statistics.BooleanStatistics;
import hive.parquet.format.ColumnChunk;
import hive.parquet.format.ColumnMetaData;
import hive.parquet.format.ConvertedType;
import hive.parquet.format.DataPageHeader;
import hive.parquet.format.DataPageHeaderV2;
import hive.parquet.format.DictionaryPageHeader;
import hive.parquet.format.Encoding;
import hive.parquet.format.FieldRepetitionType;
import hive.parquet.format.FileMetaData;
import hive.parquet.format.KeyValue;
import hive.parquet.format.PageHeader;
import hive.parquet.format.PageType;
import hive.parquet.format.RowGroup;
import hive.parquet.format.SchemaElement;
import hive.parquet.format.Statistics;
import hive.parquet.format.Type;
import hive.parquet.format.Util;
import hive.parquet.hadoop.metadata.BlockMetaData;
import hive.parquet.hadoop.metadata.ColumnChunkMetaData;
import hive.parquet.hadoop.metadata.ColumnPath;
import hive.parquet.hadoop.metadata.CompressionCodecName;
import hive.parquet.hadoop.metadata.ParquetMetadata;
import hive.parquet.io.ParquetDecodingException;
import hive.parquet.schema.GroupType;
import hive.parquet.schema.MessageType;
import hive.parquet.schema.OriginalType;
import hive.parquet.schema.PrimitiveType;
import hive.parquet.schema.Type;
import hive.parquet.schema.TypeVisitor;
import hive.parquet.schema.Types;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ParquetMetadataConverter {
    private static final Log LOG = Log.getLog(ParquetMetadataConverter.class);
    private Map<EncodingList, Set<hive.parquet.column.Encoding>> encodingLists = new HashMap<EncodingList, Set<hive.parquet.column.Encoding>>();
    public static final MetadataFilter NO_FILTER = new NoFilter();
    public static final MetadataFilter SKIP_ROW_GROUPS = new SkipMetadataFilter();

    public FileMetaData toParquetMetadata(int currentVersion, ParquetMetadata parquetMetadata) {
        List<BlockMetaData> blocks = parquetMetadata.getBlocks();
        ArrayList<RowGroup> rowGroups = new ArrayList<RowGroup>();
        int numRows = 0;
        for (BlockMetaData block : blocks) {
            numRows = (int)((long)numRows + block.getRowCount());
            this.addRowGroup(parquetMetadata, rowGroups, block);
        }
        FileMetaData fileMetaData = new FileMetaData(currentVersion, this.toParquetSchema(parquetMetadata.getFileMetaData().getSchema()), numRows, rowGroups);
        Set<Map.Entry<String, String>> keyValues = parquetMetadata.getFileMetaData().getKeyValueMetaData().entrySet();
        for (Map.Entry<String, String> keyValue : keyValues) {
            this.addKeyValue(fileMetaData, keyValue.getKey(), keyValue.getValue());
        }
        fileMetaData.setCreated_by(parquetMetadata.getFileMetaData().getCreatedBy());
        return fileMetaData;
    }

    List<SchemaElement> toParquetSchema(MessageType schema) {
        ArrayList<SchemaElement> result = new ArrayList<SchemaElement>();
        this.addToList(result, schema);
        return result;
    }

    private void addToList(final List<SchemaElement> result, hive.parquet.schema.Type field) {
        field.accept(new TypeVisitor(){

            @Override
            public void visit(PrimitiveType primitiveType) {
                SchemaElement element = new SchemaElement(primitiveType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(primitiveType.getRepetition()));
                element.setType(ParquetMetadataConverter.this.getType(primitiveType.getPrimitiveTypeName()));
                if (primitiveType.getOriginalType() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.getConvertedType(primitiveType.getOriginalType()));
                }
                if (primitiveType.getDecimalMetadata() != null) {
                    element.setPrecision(primitiveType.getDecimalMetadata().getPrecision());
                    element.setScale(primitiveType.getDecimalMetadata().getScale());
                }
                if (primitiveType.getTypeLength() > 0) {
                    element.setType_length(primitiveType.getTypeLength());
                }
                result.add(element);
            }

            @Override
            public void visit(MessageType messageType) {
                SchemaElement element = new SchemaElement(messageType.getName());
                this.visitChildren(result, messageType.asGroupType(), element);
            }

            @Override
            public void visit(GroupType groupType) {
                SchemaElement element = new SchemaElement(groupType.getName());
                element.setRepetition_type(ParquetMetadataConverter.this.toParquetRepetition(groupType.getRepetition()));
                if (groupType.getOriginalType() != null) {
                    element.setConverted_type(ParquetMetadataConverter.this.getConvertedType(groupType.getOriginalType()));
                }
                this.visitChildren(result, groupType, element);
            }

            private void visitChildren(List<SchemaElement> result2, GroupType groupType, SchemaElement element) {
                element.setNum_children(groupType.getFieldCount());
                result2.add(element);
                for (hive.parquet.schema.Type field : groupType.getFields()) {
                    ParquetMetadataConverter.this.addToList(result2, field);
                }
            }
        });
    }

    private void addRowGroup(ParquetMetadata parquetMetadata, List<RowGroup> rowGroups, BlockMetaData block) {
        List<ColumnChunkMetaData> columns = block.getColumns();
        ArrayList<ColumnChunk> parquetColumns = new ArrayList<ColumnChunk>();
        for (ColumnChunkMetaData columnMetaData : columns) {
            ColumnChunk columnChunk = new ColumnChunk(columnMetaData.getFirstDataPageOffset());
            columnChunk.file_path = block.getPath();
            columnChunk.meta_data = new ColumnMetaData(this.getType(columnMetaData.getType()), this.toFormatEncodings(columnMetaData.getEncodings()), Arrays.asList(columnMetaData.getPath().toArray()), columnMetaData.getCodec().getParquetCompressionCodec(), columnMetaData.getValueCount(), columnMetaData.getTotalUncompressedSize(), columnMetaData.getTotalSize(), columnMetaData.getFirstDataPageOffset());
            columnChunk.meta_data.dictionary_page_offset = columnMetaData.getDictionaryPageOffset();
            if (!columnMetaData.getStatistics().isEmpty()) {
                columnChunk.meta_data.setStatistics(ParquetMetadataConverter.toParquetStatistics(columnMetaData.getStatistics()));
            }
            parquetColumns.add(columnChunk);
        }
        RowGroup rowGroup = new RowGroup(parquetColumns, block.getTotalByteSize(), block.getRowCount());
        rowGroups.add(rowGroup);
    }

    private List<Encoding> toFormatEncodings(Set<hive.parquet.column.Encoding> encodings) {
        ArrayList<Encoding> converted = new ArrayList<Encoding>(encodings.size());
        for (hive.parquet.column.Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        return converted;
    }

    private Set<hive.parquet.column.Encoding> fromFormatEncodings(List<Encoding> encodings) {
        HashSet<hive.parquet.column.Encoding> converted = new HashSet();
        for (Encoding encoding : encodings) {
            converted.add(this.getEncoding(encoding));
        }
        EncodingList key = new EncodingList(converted = Collections.unmodifiableSet(converted));
        Set<hive.parquet.column.Encoding> cached = this.encodingLists.get(key);
        if (cached == null) {
            cached = converted;
            this.encodingLists.put(key, cached);
        }
        return cached;
    }

    public hive.parquet.column.Encoding getEncoding(Encoding encoding) {
        return hive.parquet.column.Encoding.valueOf(encoding.name());
    }

    public Encoding getEncoding(hive.parquet.column.Encoding encoding) {
        return Encoding.valueOf(encoding.name());
    }

    public static Statistics toParquetStatistics(hive.parquet.column.statistics.Statistics statistics) {
        Statistics stats = new Statistics();
        if (!statistics.isEmpty()) {
            stats.setNull_count(statistics.getNumNulls());
            if (statistics.hasNonNullValue()) {
                stats.setMax(statistics.getMaxBytes());
                stats.setMin(statistics.getMinBytes());
            }
        }
        return stats;
    }

    public static hive.parquet.column.statistics.Statistics fromParquetStatistics(Statistics statistics, PrimitiveType.PrimitiveTypeName type) {
        hive.parquet.column.statistics.Statistics stats = hive.parquet.column.statistics.Statistics.getStatsBasedOnType(type);
        if (statistics != null) {
            if (statistics.isSetMax() && statistics.isSetMin()) {
                stats.setMinMaxFromBytes(statistics.min.array(), statistics.max.array());
            }
            stats.setNumNulls(statistics.null_count);
        }
        return stats;
    }

    public PrimitiveType.PrimitiveTypeName getPrimitive(Type type) {
        switch (type) {
            case BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.BINARY;
            }
            case INT64: {
                return PrimitiveType.PrimitiveTypeName.INT64;
            }
            case INT32: {
                return PrimitiveType.PrimitiveTypeName.INT32;
            }
            case BOOLEAN: {
                return PrimitiveType.PrimitiveTypeName.BOOLEAN;
            }
            case FLOAT: {
                return PrimitiveType.PrimitiveTypeName.FLOAT;
            }
            case DOUBLE: {
                return PrimitiveType.PrimitiveTypeName.DOUBLE;
            }
            case INT96: {
                return PrimitiveType.PrimitiveTypeName.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown type " + type);
    }

    Type getType(PrimitiveType.PrimitiveTypeName type) {
        switch (type) {
            case INT64: {
                return Type.INT64;
            }
            case INT32: {
                return Type.INT32;
            }
            case BOOLEAN: {
                return Type.BOOLEAN;
            }
            case BINARY: {
                return Type.BYTE_ARRAY;
            }
            case FLOAT: {
                return Type.FLOAT;
            }
            case DOUBLE: {
                return Type.DOUBLE;
            }
            case INT96: {
                return Type.INT96;
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return Type.FIXED_LEN_BYTE_ARRAY;
            }
        }
        throw new RuntimeException("Unknown primitive type " + (Object)((Object)type));
    }

    OriginalType getOriginalType(ConvertedType type) {
        switch (type) {
            case UTF8: {
                return OriginalType.UTF8;
            }
            case MAP: {
                return OriginalType.MAP;
            }
            case MAP_KEY_VALUE: {
                return OriginalType.MAP_KEY_VALUE;
            }
            case LIST: {
                return OriginalType.LIST;
            }
            case ENUM: {
                return OriginalType.ENUM;
            }
            case DECIMAL: {
                return OriginalType.DECIMAL;
            }
            case DATE: {
                return OriginalType.DATE;
            }
            case TIME_MILLIS: {
                return OriginalType.TIME_MILLIS;
            }
            case TIMESTAMP_MILLIS: {
                return OriginalType.TIMESTAMP_MILLIS;
            }
            case INTERVAL: {
                return OriginalType.INTERVAL;
            }
            case INT_8: {
                return OriginalType.INT_8;
            }
            case INT_16: {
                return OriginalType.INT_16;
            }
            case INT_32: {
                return OriginalType.INT_32;
            }
            case INT_64: {
                return OriginalType.INT_64;
            }
            case UINT_8: {
                return OriginalType.UINT_8;
            }
            case UINT_16: {
                return OriginalType.UINT_16;
            }
            case UINT_32: {
                return OriginalType.UINT_32;
            }
            case UINT_64: {
                return OriginalType.UINT_64;
            }
            case JSON: {
                return OriginalType.JSON;
            }
            case BSON: {
                return OriginalType.BSON;
            }
        }
        throw new RuntimeException("Unknown converted type " + type);
    }

    ConvertedType getConvertedType(OriginalType type) {
        switch (type) {
            case UTF8: {
                return ConvertedType.UTF8;
            }
            case MAP: {
                return ConvertedType.MAP;
            }
            case MAP_KEY_VALUE: {
                return ConvertedType.MAP_KEY_VALUE;
            }
            case LIST: {
                return ConvertedType.LIST;
            }
            case ENUM: {
                return ConvertedType.ENUM;
            }
            case DECIMAL: {
                return ConvertedType.DECIMAL;
            }
            case DATE: {
                return ConvertedType.DATE;
            }
            case TIME_MILLIS: {
                return ConvertedType.TIME_MILLIS;
            }
            case TIMESTAMP_MILLIS: {
                return ConvertedType.TIMESTAMP_MILLIS;
            }
            case INTERVAL: {
                return ConvertedType.INTERVAL;
            }
            case INT_8: {
                return ConvertedType.INT_8;
            }
            case INT_16: {
                return ConvertedType.INT_16;
            }
            case INT_32: {
                return ConvertedType.INT_32;
            }
            case INT_64: {
                return ConvertedType.INT_64;
            }
            case UINT_8: {
                return ConvertedType.UINT_8;
            }
            case UINT_16: {
                return ConvertedType.UINT_16;
            }
            case UINT_32: {
                return ConvertedType.UINT_32;
            }
            case UINT_64: {
                return ConvertedType.UINT_64;
            }
            case JSON: {
                return ConvertedType.JSON;
            }
            case BSON: {
                return ConvertedType.BSON;
            }
        }
        throw new RuntimeException("Unknown original type " + (Object)((Object)type));
    }

    private void addKeyValue(FileMetaData fileMetaData, String key, String value) {
        KeyValue keyValue = new KeyValue(key);
        keyValue.value = value;
        fileMetaData.addToKey_value_metadata(keyValue);
    }

    public static final MetadataFilter range(long startOffset, long endOffset) {
        return new RangeMetadataFilter(startOffset, endOffset);
    }

    @Deprecated
    public ParquetMetadata readParquetMetadata(InputStream from) throws IOException {
        return this.readParquetMetadata(from, NO_FILTER);
    }

    static FileMetaData filterFileMetaData(FileMetaData metaData, RangeMetadataFilter filter) {
        List<RowGroup> rowGroups = metaData.getRow_groups();
        ArrayList<RowGroup> newRowGroups = new ArrayList<RowGroup>();
        for (RowGroup rowGroup : rowGroups) {
            long totalSize = 0L;
            long startIndex = ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
            for (ColumnChunk col : rowGroup.getColumns()) {
                totalSize += col.getMeta_data().getTotal_compressed_size();
            }
            long midPoint = startIndex + totalSize / 2L;
            if (!filter.contains(midPoint)) continue;
            newRowGroups.add(rowGroup);
        }
        metaData.setRow_groups(newRowGroups);
        return metaData;
    }

    static long getOffset(RowGroup rowGroup) {
        return ParquetMetadataConverter.getOffset(rowGroup.getColumns().get(0));
    }

    static long getOffset(ColumnChunk columnChunk) {
        ColumnMetaData md = columnChunk.getMeta_data();
        long offset = md.getData_page_offset();
        if (md.isSetDictionary_page_offset() && offset > md.getDictionary_page_offset()) {
            offset = md.getDictionary_page_offset();
        }
        return offset;
    }

    public ParquetMetadata readParquetMetadata(final InputStream from, MetadataFilter filter) throws IOException {
        FileMetaData fileMetaData = filter.accept(new MetadataFilterVisitor<FileMetaData, IOException>(){

            @Override
            public FileMetaData visit(NoFilter filter) throws IOException {
                return Util.readFileMetaData(from);
            }

            @Override
            public FileMetaData visit(SkipMetadataFilter filter) throws IOException {
                return Util.readFileMetaData(from, true);
            }

            @Override
            public FileMetaData visit(RangeMetadataFilter filter) throws IOException {
                return ParquetMetadataConverter.filterFileMetaData(Util.readFileMetaData(from), filter);
            }
        });
        if (Log.DEBUG) {
            LOG.debug(fileMetaData);
        }
        ParquetMetadata parquetMetadata = this.fromParquetMetadata(fileMetaData);
        if (Log.DEBUG) {
            LOG.debug(ParquetMetadata.toPrettyJSON(parquetMetadata));
        }
        return parquetMetadata;
    }

    public ParquetMetadata fromParquetMetadata(FileMetaData parquetMetadata) throws IOException {
        MessageType messageType = this.fromParquetSchema(parquetMetadata.getSchema());
        ArrayList<BlockMetaData> blocks = new ArrayList<BlockMetaData>();
        List<RowGroup> row_groups = parquetMetadata.getRow_groups();
        if (row_groups != null) {
            for (RowGroup rowGroup : row_groups) {
                BlockMetaData blockMetaData = new BlockMetaData();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                List<ColumnChunk> columns = rowGroup.getColumns();
                String filePath = columns.get(0).getFile_path();
                for (ColumnChunk columnChunk : columns) {
                    if (filePath == null && columnChunk.getFile_path() != null || filePath != null && !filePath.equals(columnChunk.getFile_path())) {
                        throw new ParquetDecodingException("all column chunks of the same row group must be in the same file for now");
                    }
                    ColumnMetaData metaData = columnChunk.meta_data;
                    ColumnPath path = this.getPath(metaData);
                    ColumnChunkMetaData column = ColumnChunkMetaData.get(path, messageType.getType(path.toArray()).asPrimitiveType().getPrimitiveTypeName(), CompressionCodecName.fromParquet(metaData.codec), this.fromFormatEncodings(metaData.encodings), ParquetMetadataConverter.fromParquetStatistics(metaData.statistics, messageType.getType(path.toArray()).asPrimitiveType().getPrimitiveTypeName()), metaData.data_page_offset, metaData.dictionary_page_offset, metaData.num_values, metaData.total_compressed_size, metaData.total_uncompressed_size);
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List<KeyValue> key_value_metadata = parquetMetadata.getKey_value_metadata();
        if (key_value_metadata != null) {
            for (KeyValue keyValue : key_value_metadata) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        return new ParquetMetadata(new hive.parquet.hadoop.metadata.FileMetaData(messageType, keyValueMetaData, parquetMetadata.getCreated_by()), blocks);
    }

    private ColumnPath getPath(ColumnMetaData metaData) {
        String[] path = metaData.path_in_schema.toArray(new String[metaData.path_in_schema.size()]);
        return ColumnPath.get(path);
    }

    MessageType fromParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> iterator = schema.iterator();
        SchemaElement root = iterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        this.buildChildren(builder, iterator, root.getNum_children());
        return builder.named(root.name);
    }

    private void buildChildren(Types.GroupBuilder builder, Iterator<SchemaElement> schema, int childrenCount) {
        for (int i = 0; i < childrenCount; ++i) {
            Types.Builder childBuilder;
            SchemaElement schemaElement = schema.next();
            if (schemaElement.type != null) {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(this.getPrimitive(schemaElement.type), this.fromParquetRepetition(schemaElement.repetition_type));
                if (schemaElement.isSetType_length()) {
                    primitiveBuilder.length(schemaElement.type_length);
                }
                if (schemaElement.isSetPrecision()) {
                    primitiveBuilder.precision(schemaElement.precision);
                }
                if (schemaElement.isSetScale()) {
                    primitiveBuilder.scale(schemaElement.scale);
                }
                childBuilder = primitiveBuilder;
            } else {
                childBuilder = builder.group(this.fromParquetRepetition(schemaElement.repetition_type));
                this.buildChildren((Types.GroupBuilder)childBuilder, schema, schemaElement.num_children);
            }
            if (schemaElement.isSetConverted_type()) {
                childBuilder.as(this.getOriginalType(schemaElement.converted_type));
            }
            if (schemaElement.isSetField_id()) {
                childBuilder.id(schemaElement.field_id);
            }
            childBuilder.named(schemaElement.name);
        }
    }

    FieldRepetitionType toParquetRepetition(Type.Repetition repetition) {
        return FieldRepetitionType.valueOf(repetition.name());
    }

    Type.Repetition fromParquetRepetition(FieldRepetitionType repetition) {
        return Type.Repetition.valueOf(repetition.name());
    }

    @Deprecated
    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, hive.parquet.column.Encoding rlEncoding, hive.parquet.column.Encoding dlEncoding, hive.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, new BooleanStatistics(), rlEncoding, dlEncoding, valuesEncoding), to);
    }

    public void writeDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, hive.parquet.column.statistics.Statistics statistics, hive.parquet.column.Encoding rlEncoding, hive.parquet.column.Encoding dlEncoding, hive.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageHeader(uncompressedSize, compressedSize, valueCount, statistics, rlEncoding, dlEncoding, valuesEncoding), to);
    }

    private PageHeader newDataPageHeader(int uncompressedSize, int compressedSize, int valueCount, hive.parquet.column.statistics.Statistics statistics, hive.parquet.column.Encoding rlEncoding, hive.parquet.column.Encoding dlEncoding, hive.parquet.column.Encoding valuesEncoding) {
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE, uncompressedSize, compressedSize);
        pageHeader.setData_page_header(new DataPageHeader(valueCount, this.getEncoding(valuesEncoding), this.getEncoding(dlEncoding), this.getEncoding(rlEncoding)));
        if (!statistics.isEmpty()) {
            pageHeader.getData_page_header().setStatistics(ParquetMetadataConverter.toParquetStatistics(statistics));
        }
        return pageHeader;
    }

    public void writeDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, hive.parquet.column.statistics.Statistics statistics, hive.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength, OutputStream to) throws IOException {
        Util.writePageHeader(this.newDataPageV2Header(uncompressedSize, compressedSize, valueCount, nullCount, rowCount, statistics, dataEncoding, rlByteLength, dlByteLength), to);
    }

    private PageHeader newDataPageV2Header(int uncompressedSize, int compressedSize, int valueCount, int nullCount, int rowCount, hive.parquet.column.statistics.Statistics<?> statistics, hive.parquet.column.Encoding dataEncoding, int rlByteLength, int dlByteLength) {
        DataPageHeaderV2 dataPageHeaderV2 = new DataPageHeaderV2(valueCount, nullCount, rowCount, this.getEncoding(dataEncoding), dlByteLength, rlByteLength);
        if (!statistics.isEmpty()) {
            dataPageHeaderV2.setStatistics(ParquetMetadataConverter.toParquetStatistics(statistics));
        }
        PageHeader pageHeader = new PageHeader(PageType.DATA_PAGE_V2, uncompressedSize, compressedSize);
        pageHeader.setData_page_header_v2(dataPageHeaderV2);
        return pageHeader;
    }

    public void writeDictionaryPageHeader(int uncompressedSize, int compressedSize, int valueCount, hive.parquet.column.Encoding valuesEncoding, OutputStream to) throws IOException {
        PageHeader pageHeader = new PageHeader(PageType.DICTIONARY_PAGE, uncompressedSize, compressedSize);
        pageHeader.setDictionary_page_header(new DictionaryPageHeader(valueCount, this.getEncoding(valuesEncoding)));
        Util.writePageHeader(pageHeader, to);
    }

    static final class RangeMetadataFilter
    extends MetadataFilter {
        final long startOffset;
        final long endOffset;

        RangeMetadataFilter(long startOffset, long endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        boolean contains(long offset) {
            return offset >= this.startOffset && offset < this.endOffset;
        }

        public String toString() {
            return "range(s:" + this.startOffset + ", e:" + this.endOffset + ")";
        }
    }

    private static final class SkipMetadataFilter
    extends MetadataFilter {
        private SkipMetadataFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "SKIP_ROW_GROUPS";
        }
    }

    private static final class NoFilter
    extends MetadataFilter {
        private NoFilter() {
        }

        @Override
        <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> visitor) throws E {
            return visitor.visit(this);
        }

        public String toString() {
            return "NO_FILTER";
        }
    }

    public static abstract class MetadataFilter {
        private MetadataFilter() {
        }

        abstract <T, E extends Throwable> T accept(MetadataFilterVisitor<T, E> var1) throws E;
    }

    private static interface MetadataFilterVisitor<T, E extends Throwable> {
        public T visit(NoFilter var1) throws E;

        public T visit(SkipMetadataFilter var1) throws E;

        public T visit(RangeMetadataFilter var1) throws E;
    }

    private static final class EncodingList {
        private final Set<hive.parquet.column.Encoding> encodings;

        public EncodingList(Set<hive.parquet.column.Encoding> encodings) {
            this.encodings = encodings;
        }

        public boolean equals(Object obj) {
            if (obj instanceof EncodingList) {
                Set<hive.parquet.column.Encoding> other = ((EncodingList)obj).encodings;
                return other.size() == this.encodings.size() && this.encodings.containsAll(other);
            }
            return false;
        }

        public int hashCode() {
            int result = 1;
            for (hive.parquet.column.Encoding element : this.encodings) {
                result = 31 * result + (element == null ? 0 : element.hashCode());
            }
            return result;
        }
    }
}

