/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.filter2.recordlevel;

import hive.parquet.Preconditions;
import hive.parquet.column.Dictionary;
import hive.parquet.filter2.recordlevel.IncrementallyUpdatedFilterPredicate;
import hive.parquet.io.api.Binary;
import hive.parquet.io.api.PrimitiveConverter;

public class FilteringPrimitiveConverter
extends PrimitiveConverter {
    private final PrimitiveConverter delegate;
    private final IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors;

    public FilteringPrimitiveConverter(PrimitiveConverter delegate, IncrementallyUpdatedFilterPredicate.ValueInspector[] valueInspectors) {
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.valueInspectors = Preconditions.checkNotNull(valueInspectors, "valueInspectors");
    }

    @Override
    public boolean hasDictionarySupport() {
        return false;
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        throw new UnsupportedOperationException("FilteringPrimitiveConverter doesn't have dictionary support");
    }

    @Override
    public void addValueFromDictionary(int dictionaryId) {
        throw new UnsupportedOperationException("FilteringPrimitiveConverter doesn't have dictionary support");
    }

    @Override
    public void addBinary(Binary value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addBinary(value);
    }

    @Override
    public void addBoolean(boolean value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addBoolean(value);
    }

    @Override
    public void addDouble(double value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addDouble(value);
    }

    @Override
    public void addFloat(float value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addFloat(value);
    }

    @Override
    public void addInt(int value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addInt(value);
    }

    @Override
    public void addLong(long value) {
        for (IncrementallyUpdatedFilterPredicate.ValueInspector valueInspector : this.valueInspectors) {
            valueInspector.update(value);
        }
        this.delegate.addLong(value);
    }
}

