/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.values.plain;

import hive.parquet.Log;
import hive.parquet.bytes.BytesInput;
import hive.parquet.bytes.CapacityByteArrayOutputStream;
import hive.parquet.bytes.LittleEndianDataOutputStream;
import hive.parquet.column.Encoding;
import hive.parquet.column.values.ValuesWriter;
import hive.parquet.column.values.plain.PlainValuesWriter;
import hive.parquet.io.ParquetEncodingException;
import hive.parquet.io.api.Binary;
import java.io.IOException;

public class FixedLenByteArrayPlainValuesWriter
extends ValuesWriter {
    private static final Log LOG = Log.getLog(PlainValuesWriter.class);
    private CapacityByteArrayOutputStream arrayOut;
    private LittleEndianDataOutputStream out;
    private int length;

    public FixedLenByteArrayPlainValuesWriter(int length, int initialSize, int pageSize) {
        this.length = length;
        this.arrayOut = new CapacityByteArrayOutputStream(initialSize, pageSize);
        this.out = new LittleEndianDataOutputStream(this.arrayOut);
    }

    @Override
    public final void writeBytes(Binary v) {
        if (v.length() != this.length) {
            throw new IllegalArgumentException("Fixed Binary size " + v.length() + " does not match field type length " + this.length);
        }
        try {
            v.writeTo(this.out);
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write fixed bytes", e);
        }
    }

    @Override
    public long getBufferedSize() {
        return this.arrayOut.size();
    }

    @Override
    public BytesInput getBytes() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            throw new ParquetEncodingException("could not write page", e);
        }
        if (Log.DEBUG) {
            LOG.debug("writing a buffer of size " + this.arrayOut.size());
        }
        return BytesInput.from(this.arrayOut);
    }

    @Override
    public void reset() {
        this.arrayOut.reset();
    }

    @Override
    public long getAllocatedSize() {
        return this.arrayOut.getCapacity();
    }

    @Override
    public Encoding getEncoding() {
        return Encoding.PLAIN;
    }

    @Override
    public String memUsageString(String prefix) {
        return this.arrayOut.memUsageString(prefix + " PLAIN");
    }
}

