/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.statistics;

import hive.parquet.bytes.BytesUtils;
import hive.parquet.column.statistics.Statistics;

public class IntStatistics
extends Statistics<Integer> {
    private int max;
    private int min;

    @Override
    public void updateStats(int value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        IntStatistics intStats = (IntStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(intStats.getMin(), intStats.getMax());
        } else {
            this.updateStats(intStats.getMin(), intStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = BytesUtils.bytesToInt(maxBytes);
        this.min = BytesUtils.bytesToInt(minBytes);
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.intToBytes(this.max);
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.intToBytes(this.min);
    }

    @Override
    public String toString() {
        if (this.hasNonNullValue()) {
            return String.format("min: %d, max: %d, num_nulls: %d", this.min, this.max, this.getNumNulls());
        }
        if (!this.isEmpty()) {
            return String.format("num_nulls: %d, min/max is not defined", this.getNumNulls());
        }
        return "no stats for this column";
    }

    public void updateStats(int min_value, int max_value) {
        if (min_value < this.min) {
            this.min = min_value;
        }
        if (max_value > this.max) {
            this.max = max_value;
        }
    }

    public void initializeStats(int min_value, int max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    @Override
    public Integer genericGetMin() {
        return this.min;
    }

    @Override
    public Integer genericGetMax() {
        return this.max;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMinMax(int min, int max) {
        this.max = max;
        this.min = min;
        this.markAsNotEmpty();
    }
}

