/*
 * Decompiled with CFR 0.152.
 */
package hive.parquet.column.impl;

import hive.parquet.column.ColumnDescriptor;
import hive.parquet.column.ColumnReadStore;
import hive.parquet.column.ColumnReader;
import hive.parquet.column.impl.ColumnReaderImpl;
import hive.parquet.column.page.PageReadStore;
import hive.parquet.column.page.PageReader;
import hive.parquet.io.api.Converter;
import hive.parquet.io.api.GroupConverter;
import hive.parquet.io.api.PrimitiveConverter;
import hive.parquet.schema.GroupType;
import hive.parquet.schema.MessageType;
import hive.parquet.schema.Type;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema) {
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path) {
        return this.newMemColumnReader(path, this.pageReadStore.getPageReader(path));
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path);
        return new ColumnReaderImpl(path, pageReader, converter);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        for (String fieldName : path.getPath()) {
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName);
            currentType = groupType.getType(fieldName);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

