/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.util.javac;

import hive.org.apache.calcite.util.Util;
import hive.org.apache.calcite.util.javac.JavaCompiler;
import hive.org.apache.calcite.util.javac.JavaCompilerArgs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.janino.JavaSourceClassLoader;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.resource.MapResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;

public class JaninoCompiler
implements JavaCompiler {
    public JaninoCompilerArgs args = new JaninoCompilerArgs();
    private AccountingClassLoader classLoader;

    @Override
    public void compile() {
        assert (this.args.destdir != null);
        assert (this.args.fullClassName != null);
        assert (this.args.source != null);
        Object parentClassLoader = this.args.getClassLoader();
        if (this.classLoader != null) {
            parentClassLoader = this.classLoader;
        }
        HashMap<String, byte[]> sourceMap = new HashMap<String, byte[]>();
        sourceMap.put(ClassFile.getSourceResourceName((String)this.args.fullClassName), this.args.source.getBytes());
        MapResourceFinder sourceFinder = new MapResourceFinder(sourceMap);
        this.classLoader = new AccountingClassLoader((ClassLoader)parentClassLoader, (ResourceFinder)sourceFinder, null, this.args.destdir == null ? null : new File(this.args.destdir));
        try {
            this.classLoader.loadClass(this.args.fullClassName);
        }
        catch (ClassNotFoundException ex) {
            throw Util.newInternal(ex, "while compiling " + this.args.fullClassName);
        }
    }

    @Override
    public JavaCompilerArgs getArgs() {
        return this.args;
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public int getTotalByteCodeSize() {
        return this.classLoader.getTotalByteCodeSize();
    }

    private static class AccountingClassLoader
    extends JavaSourceClassLoader {
        private final File destDir;
        private int nBytes;

        public AccountingClassLoader(ClassLoader parentClassLoader, ResourceFinder sourceFinder, String optionalCharacterEncoding, File destDir) {
            super(parentClassLoader, sourceFinder, optionalCharacterEncoding);
            this.destDir = destDir;
        }

        int getTotalByteCodeSize() {
            return this.nBytes;
        }

        public Map generateBytecodes(String name) throws ClassNotFoundException {
            Map map = super.generateBytecodes(name);
            if (map == null) {
                return map;
            }
            if (this.destDir != null) {
                try {
                    for (Map.Entry entry : map.entrySet()) {
                        File file = new File(this.destDir, (String)entry.getKey() + ".class");
                        FileOutputStream fos = new FileOutputStream(file);
                        fos.write((byte[])entry.getValue());
                        fos.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            for (Object object : map.values()) {
                byte[] bytes = (byte[])object;
                this.nBytes += bytes.length;
            }
            return map;
        }
    }

    public static class JaninoCompilerArgs
    extends JavaCompilerArgs {
        String destdir;
        String fullClassName;
        String source;

        @Override
        public boolean supportsSetSource() {
            return true;
        }

        @Override
        public void setDestdir(String destdir) {
            super.setDestdir(destdir);
            this.destdir = destdir;
        }

        @Override
        public void setSource(String source, String fileName) {
            this.source = source;
            this.addFile(fileName);
        }

        @Override
        public void setFullClassName(String fullClassName) {
            this.fullClassName = fullClassName;
        }
    }
}

