/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.tools;

import hive.com.google.common.base.Function;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.ImmutableSet;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.linq4j.Ord;
import hive.org.apache.calcite.plan.Context;
import hive.org.apache.calcite.plan.Contexts;
import hive.org.apache.calcite.plan.RelOptCluster;
import hive.org.apache.calcite.plan.RelOptSchema;
import hive.org.apache.calcite.plan.RelOptTable;
import hive.org.apache.calcite.rel.RelCollations;
import hive.org.apache.calcite.rel.RelFieldCollation;
import hive.org.apache.calcite.rel.RelNode;
import hive.org.apache.calcite.rel.core.AggregateCall;
import hive.org.apache.calcite.rel.core.JoinRelType;
import hive.org.apache.calcite.rel.core.Project;
import hive.org.apache.calcite.rel.core.RelFactories;
import hive.org.apache.calcite.rel.core.Sort;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rex.RexBuilder;
import hive.org.apache.calcite.rex.RexCall;
import hive.org.apache.calcite.rex.RexInputRef;
import hive.org.apache.calcite.rex.RexLiteral;
import hive.org.apache.calcite.rex.RexNode;
import hive.org.apache.calcite.rex.RexUtil;
import hive.org.apache.calcite.schema.SchemaPlus;
import hive.org.apache.calcite.server.CalciteServerStatement;
import hive.org.apache.calcite.sql.SqlAggFunction;
import hive.org.apache.calcite.sql.SqlKind;
import hive.org.apache.calcite.sql.SqlOperator;
import hive.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import hive.org.apache.calcite.sql.type.SqlTypeName;
import hive.org.apache.calcite.tools.FrameworkConfig;
import hive.org.apache.calcite.tools.Frameworks;
import hive.org.apache.calcite.util.ImmutableBitSet;
import hive.org.apache.calcite.util.NlsString;
import hive.org.apache.calcite.util.Stacks;
import hive.org.apache.calcite.util.Util;
import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;

public class RelBuilder {
    private static final Function<RexNode, String> FN_TYPE = new Function<RexNode, String>(){

        @Override
        public String apply(RexNode input) {
            return input + ": " + input.getType();
        }
    };
    private final RelOptCluster cluster;
    private final RelOptSchema relOptSchema;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SortFactory sortFactory;
    private final RelFactories.SetOpFactory setOpFactory;
    private final RelFactories.JoinFactory joinFactory;
    private final RelFactories.ValuesFactory valuesFactory;
    private final RelFactories.TableScanFactory scanFactory;
    private final List<RelNode> stack = new ArrayList<RelNode>();

    private RelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.aggregateFactory = Util.first(context.unwrap(RelFactories.AggregateFactory.class), RelFactories.DEFAULT_AGGREGATE_FACTORY);
        this.filterFactory = Util.first(context.unwrap(RelFactories.FilterFactory.class), RelFactories.DEFAULT_FILTER_FACTORY);
        this.projectFactory = Util.first(context.unwrap(RelFactories.ProjectFactory.class), RelFactories.DEFAULT_PROJECT_FACTORY);
        this.sortFactory = Util.first(context.unwrap(RelFactories.SortFactory.class), RelFactories.DEFAULT_SORT_FACTORY);
        this.setOpFactory = Util.first(context.unwrap(RelFactories.SetOpFactory.class), RelFactories.DEFAULT_SET_OP_FACTORY);
        this.joinFactory = Util.first(context.unwrap(RelFactories.JoinFactory.class), RelFactories.DEFAULT_JOIN_FACTORY);
        this.valuesFactory = Util.first(context.unwrap(RelFactories.ValuesFactory.class), RelFactories.DEFAULT_VALUES_FACTORY);
        this.scanFactory = Util.first(context.unwrap(RelFactories.TableScanFactory.class), RelFactories.DEFAULT_TABLE_SCAN_FACTORY);
    }

    public static RelBuilder create(FrameworkConfig config) {
        final RelOptCluster[] clusters = new RelOptCluster[]{null};
        final RelOptSchema[] relOptSchemas = new RelOptSchema[]{null};
        Frameworks.withPrepare(new Frameworks.PrepareAction<Void>(config){

            @Override
            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                clusters[0] = cluster;
                relOptSchemas[0] = relOptSchema;
                return null;
            }
        });
        return new RelBuilder(config.getContext(), clusters[0], relOptSchemas[0]);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public static ProtoRelBuilder proto(final Context context) {
        return new ProtoRelBuilder(){

            @Override
            public RelBuilder create(RelOptCluster cluster, RelOptSchema schema) {
                return new RelBuilder(context, cluster, schema);
            }
        };
    }

    public RelBuilder push(RelNode node) {
        Stacks.push(this.stack, node);
        return this;
    }

    public RelNode build() {
        if (this.stack.size() < 1) {
            throw new IllegalArgumentException("expected stack size 1, but was " + this.stack.size() + ": " + this.stack);
        }
        return Stacks.pop(this.stack);
    }

    public RelNode peek() {
        return Stacks.peek(this.stack);
    }

    public RelNode peek(int n) {
        return Stacks.peek(n, this.stack);
    }

    public RexNode literal(Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            return rexBuilder.constantNull();
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral((Boolean)value);
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        RelNode input = this.peek(inputCount - 1 - inputOrdinal);
        RelDataType rowType = input.getRowType();
        int ordinal = rowType.getFieldNames().indexOf(fieldName);
        if (ordinal < 0) {
            throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + rowType.getFieldNames());
        }
        return this.field(inputCount, inputOrdinal, ordinal);
    }

    public RexInputRef field(int fieldOrdinal) {
        return this.field(1, 0, fieldOrdinal);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        RelNode input = this.peek(inputCount - 1 - inputOrdinal);
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        return this.cluster.getRexBuilder().makeInputRef(input, fieldOrdinal);
    }

    public RexNode call(SqlOperator operator, RexNode ... operands) {
        ImmutableList<RexNode> operandList;
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList = ImmutableList.copyOf(operands));
        if (type == null) {
            throw new IllegalArgumentException("cannot derive type: " + operator + "; operands: " + Lists.transform(operandList, FN_TYPE));
        }
        return builder.makeCall(type, operator, operandList);
    }

    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.cluster.getRexBuilder().makeCall(operator, ImmutableList.copyOf(operands));
    }

    public RexNode and(RexNode ... operands) {
        return this.and(ImmutableList.copyOf(operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return RexUtil.composeConjunction(this.cluster.getRexBuilder(), operands, false);
    }

    public RexNode or(RexNode ... operands) {
        return this.or(ImmutableList.copyOf(operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction(this.cluster.getRexBuilder(), operands, false);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias) {
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, this.literal(alias));
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public GroupKey groupKey() {
        return this.groupKey(ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey(ImmutableList.copyOf(nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl(ImmutableList.copyOf(nodes));
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int fieldOrdinal : fieldOrdinals) {
            builder.add(this.field(fieldOrdinal));
        }
        return this.groupKey(builder.build());
    }

    public GroupKey groupKey(String ... fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add(this.field(fieldName));
        }
        return this.groupKey(builder.build());
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, String alias, RexNode ... operands) {
        return new AggCallImpl(aggFunction, distinct, alias, ImmutableList.copyOf(operands));
    }

    public AggCall count(boolean distinct, String alias, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, alias, operands);
    }

    public AggCall countStar(String alias) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, false, alias, new RexNode[0]);
    }

    public AggCall sum(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, alias, operand);
    }

    public AggCall avg(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, alias, operand);
    }

    public AggCall min(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, alias, operand);
    }

    public AggCall max(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, alias, operand);
    }

    public RelBuilder scan(String tableName) {
        RelOptTable relOptTable = this.relOptSchema.getTableForMember(ImmutableList.of(tableName));
        RelNode scan = this.scanFactory.createScan(this.cluster, relOptTable);
        this.push(scan);
        return this;
    }

    public RelBuilder filter(RexNode ... predicates) {
        return this.filter(ImmutableList.copyOf(predicates));
    }

    public RelBuilder filter(Iterable<? extends RexNode> predicates) {
        RexNode x = RexUtil.composeConjunction(this.cluster.getRexBuilder(), predicates, true);
        if (x != null) {
            RelNode filter = this.filterFactory.createFilter(this.build(), x);
            this.push(filter);
        }
        return this;
    }

    public RelBuilder project(List<RexNode> nodes) {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<RexNode> exprList = Lists.newArrayList(nodes);
        for (RexNode node : nodes) {
            names.add(this.inferAlias(exprList, node));
        }
        RelNode project = this.projectFactory.createProject(this.build(), ImmutableList.copyOf(exprList), names);
        this.push(project);
        return this;
    }

    public RelBuilder project(RexNode ... nodes) {
        return this.project(ImmutableList.copyOf(nodes));
    }

    private String inferAlias(List<RexNode> exprList, RexNode expr) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return this.peek(0).getRowType().getFieldNames().get(ref.getIndex());
            }
            case CAST: {
                return this.inferAlias(exprList, ((RexCall)expr).getOperands().get(0));
            }
            case AS: {
                int i;
                RexCall call = (RexCall)expr;
                while ((i = exprList.indexOf(expr)) >= 0) {
                    exprList.set(i, call.getOperands().get(0));
                }
                return ((NlsString)((RexLiteral)call.getOperands().get(1)).getValue()).getValue();
            }
        }
        return null;
    }

    public RelBuilder distinct() {
        return this.aggregate(this.groupKey(), new AggCall[0]);
    }

    public RelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate(groupKey, ImmutableList.copyOf(aggCalls));
    }

    public RelBuilder aggregate(GroupKey groupKey, Iterable<AggCall> aggCalls) {
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        for (RexNode node : ((GroupKeyImpl)groupKey).nodes) {
            builder.set(RelBuilder.registerExpression(extraNodes, node));
        }
        ImmutableBitSet groupSet = builder.build();
        for (AggCall aggCall : aggCalls) {
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            for (RexNode operand : aggCall1.operands) {
                RelBuilder.registerExpression(extraNodes, operand);
            }
        }
        if (extraNodes.size() > inputRowType.getFieldCount()) {
            this.project(extraNodes);
        }
        RelNode r = this.build();
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCall aggCall : aggCalls) {
            ArrayList<Integer> args = new ArrayList<Integer>();
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            for (RexNode operand : aggCall1.operands) {
                args.add(RelBuilder.registerExpression(extraNodes, operand));
            }
            aggregateCalls.add(AggregateCall.create(aggCall1.aggFunction, aggCall1.distinct, args, -1, groupSet.cardinality(), r, null, aggCall1.alias));
        }
        RelNode aggregate = this.aggregateFactory.createAggregate(r, false, groupSet, ImmutableList.of(groupSet), aggregateCalls);
        this.push(aggregate);
        return this;
    }

    private List<RexNode> projects(RelDataType inputRowType) {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (RelDataTypeField field : inputRowType.getFieldList()) {
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            exprList.add(rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return exprList;
    }

    private static int registerExpression(List<RexNode> exprList, RexNode node) {
        int i = exprList.indexOf(node);
        if (i < 0) {
            i = exprList.size();
            exprList.add(node);
        }
        return i;
    }

    public RelBuilder union(boolean all) {
        RelNode left = this.build();
        RelNode right = this.build();
        RelNode union = this.setOpFactory.createSetOp(SqlKind.UNION, ImmutableList.of(left, right), all);
        this.push(union);
        return this;
    }

    public RelBuilder intersect(boolean all) {
        RelNode left = this.build();
        RelNode right = this.build();
        RelNode intersect = this.setOpFactory.createSetOp(SqlKind.INTERSECT, ImmutableList.of(left, right), all);
        this.push(intersect);
        return this;
    }

    public RelBuilder minus(boolean all) {
        RelNode left = this.build();
        RelNode right = this.build();
        RelNode except = this.setOpFactory.createSetOp(SqlKind.EXCEPT, ImmutableList.of(left, right), all);
        this.push(except);
        return this;
    }

    public RelBuilder join(JoinRelType joinType, RexNode condition) {
        RelNode left = this.build();
        RelNode right = this.build();
        RelNode join = this.joinFactory.createJoin(left, right, condition, joinType, ImmutableSet.of(), false);
        this.push(join);
        return this;
    }

    public RelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.call((SqlOperator)SqlStdOperatorTable.EQUALS, this.field(2, 0, fieldName), this.field(2, 1, fieldName)));
        }
        RexNode condition = RexUtil.composeConjunction(this.cluster.getRexBuilder(), conditions, false);
        return this.join(joinType, condition);
    }

    public RelBuilder values(String[] fieldNames, Object ... values) {
        if (fieldNames == null || fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        final int rowCount = values.length / fieldNames.length;
        for (Ord fieldName : Ord.zip((Object[])fieldNames)) {
            if (!this.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' are null; cannot deduce type");
        }
        final ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        RelDataTypeFactory.FieldInfoBuilder rowTypeBuilder = this.cluster.getTypeFactory().builder();
        for (final Ord fieldName : Ord.zip((Object[])fieldNames)) {
            String name = fieldName.e != null ? (String)fieldName.e : "expr$" + fieldName.i;
            RelDataType type = this.cluster.getTypeFactory().leastRestrictive((List<RelDataType>)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((ImmutableList)tupleList.get(index)).get(fieldName.i)).getType();
                }

                @Override
                public int size() {
                    return rowCount;
                }
            });
            rowTypeBuilder.add(name, type);
        }
        RelDataType rowType = rowTypeBuilder.build();
        return this.values(rowType, tupleList);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add((RexLiteral)this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add(ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private boolean allNull(Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public RelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    protected RelBuilder values(RelDataType rowType, Iterable<ImmutableList<RexLiteral>> tupleList) {
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public RelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, ImmutableList.of());
    }

    public RelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add(field < 0 ? this.desc(this.field(-field - 1)) : this.field(field));
        }
        return this.sortLimit(-1, -1, builder.build());
    }

    public RelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, ImmutableList.copyOf(nodes));
    }

    public RelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public RelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, ImmutableList.copyOf(nodes));
    }

    public RelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        boolean addedFields;
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        ImmutableList<RexNode> originalExtraNodes = ImmutableList.copyOf(extraNodes);
        for (RexNode rexNode : nodes) {
            fieldCollations.add(RelBuilder.collation(rexNode, RelFieldCollation.Direction.ASCENDING, RelFieldCollation.NullDirection.UNSPECIFIED, extraNodes));
        }
        RexNode offsetNode = offset <= 0 ? null : this.literal(offset);
        RexNode rexNode = fetch < 0 ? null : this.literal(fetch);
        boolean bl = addedFields = extraNodes.size() > originalExtraNodes.size();
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (!addedFields);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    Stacks.pop(this.stack);
                    this.push(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.build(), sort2.collation, offsetNode, rexNode);
                    this.push(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    Stacks.pop(this.stack);
                    this.push(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.build(), sort2.collation, offsetNode, rexNode);
                    this.push(sort);
                    this.project(project.getProjects());
                    return this;
                }
            }
        }
        if (addedFields) {
            this.project(extraNodes);
        }
        RelNode sort = this.sortFactory.createSort(this.build(), RelCollations.of(fieldCollations), offsetNode, rexNode);
        this.push(sort);
        if (addedFields) {
            this.project(originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, nullDirection);
            }
            case DESCENDING: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return RelBuilder.collation(((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, nullDirection);
    }

    public static interface ProtoRelBuilder {
        public RelBuilder create(RelOptCluster var1, RelOptSchema var2);
    }

    private static class AggCallImpl
    implements AggCall {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final String alias;
        private final ImmutableList<RexNode> operands;

        public AggCallImpl(SqlAggFunction aggFunction, boolean distinct, String alias, ImmutableList<RexNode> operands) {
            this.aggFunction = aggFunction;
            this.distinct = distinct;
            this.alias = alias;
            this.operands = operands;
        }
    }

    private static class GroupKeyImpl
    implements GroupKey {
        private final ImmutableList<RexNode> nodes;

        GroupKeyImpl(ImmutableList<RexNode> nodes) {
            this.nodes = nodes;
        }
    }

    public static interface GroupKey {
    }

    public static interface AggCall {
    }
}

