/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeFactory;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlWithItem;
import hive.org.apache.calcite.sql.validate.AbstractNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.util.Pair;

class WithItemNamespace
extends AbstractNamespace {
    private final SqlWithItem withItem;

    WithItemNamespace(SqlValidatorImpl validator, SqlWithItem withItem, SqlNode enclosingNode) {
        super(validator, enclosingNode);
        this.withItem = withItem;
    }

    @Override
    protected RelDataType validateImpl() {
        SqlValidatorNamespace childNs = this.validator.getNamespace(this.withItem.query);
        RelDataType rowType = childNs.getRowTypeSansSystemColumns();
        if (this.withItem.columnList == null) {
            return rowType;
        }
        RelDataTypeFactory.FieldInfoBuilder builder = this.validator.getTypeFactory().builder();
        for (Pair<SqlNode, RelDataTypeField> pair : Pair.zip(this.withItem.columnList, rowType.getFieldList())) {
            builder.add(((SqlIdentifier)pair.left).getSimple(), ((RelDataTypeField)pair.right).getType());
        }
        return builder.build();
    }

    @Override
    public SqlNode getNode() {
        return this.withItem;
    }

    @Override
    public String translate(String name) {
        if (this.withItem.columnList == null) {
            return name;
        }
        RelDataType underlyingRowType = this.validator.getValidatedNodeType(this.withItem.query);
        int i = 0;
        for (RelDataTypeField field : this.rowType.getFieldList()) {
            if (field.getName().equals(name)) {
                return underlyingRowType.getFieldList().get(i).getName();
            }
            ++i;
        }
        throw new AssertionError((Object)("unknown field '" + name + "' in rowtype " + underlyingRowType));
    }
}

