/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Lists;
import hive.org.apache.calcite.rel.type.RelDataType;
import hive.org.apache.calcite.rel.type.RelDataTypeField;
import hive.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import hive.org.apache.calcite.sql.SqlCall;
import hive.org.apache.calcite.sql.SqlDataTypeSpec;
import hive.org.apache.calcite.sql.SqlIdentifier;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.SqlNodeList;
import hive.org.apache.calcite.sql.parser.SqlParserPos;
import hive.org.apache.calcite.sql.validate.AbstractNamespace;
import hive.org.apache.calcite.sql.validate.SqlModality;
import hive.org.apache.calcite.sql.validate.SqlMonotonicity;
import hive.org.apache.calcite.sql.validate.SqlValidatorImpl;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import hive.org.apache.calcite.sql.validate.SqlValidatorTable;
import hive.org.apache.calcite.sql.validate.TableNamespace;
import hive.org.apache.calcite.util.Pair;
import hive.org.apache.calcite.util.Static;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class IdentifierNamespace
extends AbstractNamespace {
    private final SqlIdentifier id;
    private final SqlValidatorScope parentScope;
    private final SqlNodeList extendList;
    private SqlValidatorNamespace resolvedNamespace;
    private List<Pair<SqlNode, SqlMonotonicity>> monotonicExprs;

    IdentifierNamespace(SqlValidatorImpl validator, SqlIdentifier id, @Nullable SqlNodeList extendList, SqlNode enclosingNode, SqlValidatorScope parentScope) {
        super(validator, enclosingNode);
        this.id = id;
        this.extendList = extendList;
        this.parentScope = parentScope;
        assert (parentScope != null);
    }

    IdentifierNamespace(SqlValidatorImpl validator, SqlNode node, SqlNode enclosingNode, SqlValidatorScope parentScope) {
        this(validator, (SqlIdentifier)IdentifierNamespace.split((SqlNode)node).left, (SqlNodeList)IdentifierNamespace.split((SqlNode)node).right, enclosingNode, parentScope);
    }

    protected static Pair<SqlIdentifier, SqlNodeList> split(SqlNode node) {
        switch (node.getKind()) {
            case EXTEND: {
                SqlCall call = (SqlCall)node;
                return Pair.of((SqlIdentifier)call.getOperandList().get(0), (SqlNodeList)call.getOperandList().get(1));
            }
        }
        return Pair.of((SqlIdentifier)node, null);
    }

    @Override
    public RelDataType validateImpl() {
        this.resolvedNamespace = this.parentScope.getTableNamespace(this.id.names);
        if (this.resolvedNamespace == null) {
            throw this.validator.newValidationError(this.id, Static.RESOURCE.tableNameNotFound(this.id.toString()));
        }
        if (this.resolvedNamespace instanceof TableNamespace) {
            List<String> qualifiedNames;
            SqlValidatorTable table = this.resolvedNamespace.getTable();
            if (this.validator.shouldExpandIdentifiers() && (qualifiedNames = table.getQualifiedName()) != null) {
                ArrayList<SqlParserPos> poses = new ArrayList<SqlParserPos>(Collections.nCopies(qualifiedNames.size(), this.id.getParserPosition()));
                int offset = qualifiedNames.size() - this.id.names.size();
                if (offset >= 0) {
                    for (int i = 0; i < this.id.names.size(); ++i) {
                        poses.set(i + offset, this.id.getComponentParserPosition(i));
                    }
                }
                this.id.setNames(qualifiedNames, poses);
            }
        }
        RelDataType rowType = this.resolvedNamespace.getRowType();
        if (this.extendList != null) {
            ArrayList<RelDataTypeField> fields = Lists.newArrayList();
            Iterator<SqlNode> extendIterator = this.extendList.iterator();
            while (extendIterator.hasNext()) {
                SqlIdentifier id = (SqlIdentifier)extendIterator.next();
                SqlDataTypeSpec type = (SqlDataTypeSpec)extendIterator.next();
                fields.add(new RelDataTypeFieldImpl(id.getSimple(), fields.size(), type.deriveType(this.validator)));
            }
            if (!(this.resolvedNamespace instanceof TableNamespace)) {
                throw new RuntimeException("cannot convert");
            }
            this.resolvedNamespace = ((TableNamespace)this.resolvedNamespace).extend(fields);
            rowType = this.resolvedNamespace.getRowType();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        List<RelDataTypeField> fields = rowType.getFieldList();
        for (RelDataTypeField field : fields) {
            String fieldName = field.getName();
            SqlMonotonicity monotonicity = this.resolvedNamespace.getMonotonicity(fieldName);
            if (monotonicity == SqlMonotonicity.NOT_MONOTONIC) continue;
            builder.add(Pair.of(new SqlIdentifier(fieldName, SqlParserPos.ZERO), monotonicity));
        }
        this.monotonicExprs = builder.build();
        return rowType;
    }

    public SqlIdentifier getId() {
        return this.id;
    }

    @Override
    public SqlNode getNode() {
        return this.id;
    }

    @Override
    public SqlValidatorNamespace resolve() {
        assert (this.resolvedNamespace != null) : "must call validate first";
        return this.resolvedNamespace.resolve();
    }

    @Override
    public String translate(String name) {
        return this.resolvedNamespace.translate(name);
    }

    @Override
    public SqlValidatorTable getTable() {
        return this.resolve().getTable();
    }

    @Override
    public List<Pair<SqlNode, SqlMonotonicity>> getMonotonicExprs() {
        return this.monotonicExprs;
    }

    @Override
    public SqlMonotonicity getMonotonicity(String columnName) {
        SqlValidatorTable table = this.getTable();
        return table.getMonotonicity(columnName);
    }

    @Override
    public boolean supportsModality(SqlModality modality) {
        SqlValidatorTable table = this.getTable();
        if (table == null) {
            return modality == SqlModality.RELATION;
        }
        return table.supportsModality(modality);
    }
}

