/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.calcite.sql.validate;

import hive.com.google.common.collect.ImmutableCollection;
import hive.com.google.common.collect.ImmutableList;
import hive.com.google.common.collect.Sets;
import hive.org.apache.calcite.linq4j.Linq4j;
import hive.org.apache.calcite.linq4j.function.Function1;
import hive.org.apache.calcite.linq4j.function.Predicate1;
import hive.org.apache.calcite.sql.SqlNode;
import hive.org.apache.calcite.sql.validate.DelegatingScope;
import hive.org.apache.calcite.sql.validate.SchemaNamespace;
import hive.org.apache.calcite.sql.validate.SqlMoniker;
import hive.org.apache.calcite.sql.validate.SqlMonikerType;
import hive.org.apache.calcite.sql.validate.SqlValidatorNamespace;
import hive.org.apache.calcite.sql.validate.SqlValidatorScope;
import java.util.List;
import java.util.Set;

class CatalogScope
extends DelegatingScope {
    final ImmutableList<String> names;
    private final Set<List<String>> schemaNames;

    CatalogScope(SqlValidatorScope parent, List<String> names) {
        super(parent);
        this.names = ImmutableList.copyOf(names);
        this.schemaNames = (Set)Linq4j.asEnumerable(this.validator.getCatalogReader().getAllSchemaObjectNames(ImmutableList.of())).where((Predicate1)new Predicate1<SqlMoniker>(){

            public boolean apply(SqlMoniker input) {
                return input.getType() == SqlMonikerType.SCHEMA;
            }
        }).select((Function1)new Function1<SqlMoniker, List<String>>(){

            public List<String> apply(SqlMoniker input) {
                return input.getFullyQualifiedNames();
            }
        }).into(Sets.newHashSet());
    }

    @Override
    public SqlNode getNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlValidatorNamespace resolve(List<String> names, SqlValidatorScope[] ancestorOut, int[] offsetOut) {
        ImmutableCollection nameList = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(this.names)).addAll(names)).build();
        if (this.schemaNames.contains(nameList)) {
            return new SchemaNamespace(this.validator, (ImmutableList<String>)nameList);
        }
        return null;
    }
}

